// Include gulp
var gulp = require('gulp');
var path = require('path');

// Include Plugins
var sass         = require( 'gulp-sass' )( require( 'node-sass' ) );
var sassGlob     = require( 'gulp-sass-glob' );
var sourcemaps   = require( 'gulp-sourcemaps' );
var concat       = require( 'gulp-concat' );
var concatCss    = require( 'gulp-concat-css' );
var uglify       = require( 'gulp-uglify' );
var rename       = require( 'gulp-rename' );
var cssmin       = require( 'gulp-clean-css' );
var autoprefixer = require( 'gulp-autoprefixer' );
var browserSync  = require( 'browser-sync' ).create();
var jshint       = require( 'gulp-jshint' );

var plugins = [
];

var pluginsJSTasks = [];
var pluginsSASSTasks = [];
plugins.forEach(function (name) {
    pluginsJSTasks.push(name + '-js');
    pluginsSASSTasks.push(name + '-sass');
});

// Concatenate plugins js and scss files and minify it
plugins.forEach(function (name) {
    gulp.task(name + '-js', function () {
        return gulp.src([
                '../../../../plugins/solene-' + name + '/**/assets/js/modules/*.js'
            ])
            .pipe(concat(name + '.js'))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/js'))
            .pipe(uglify())
            .pipe(rename({suffix: '.min'}))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/js'));
    });

    gulp.task(name + '-sass', function () {
        return gulp.src('../../../../plugins/solene-' + name + '/assets/css/scss/*.scss')
            .pipe(sourcemaps.init({loadMaps: true}))
            .pipe(sassGlob())
            .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
            .pipe(autoprefixer({
                overrideBrowserslist: ['last 3 versions'],
                cascade: false
            }))
            .pipe(sourcemaps.write('../../../../plugins/solene-' + name + '/assets/css'))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/css'))
            .pipe(cssmin())
            .pipe(rename({suffix: '.min'}))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/css'))
            .pipe(browserSync.stream());
    });
});

// Call all plugins sass tasks
gulp.task('plugins-sass', Object.keys(pluginsSASSTasks).length !== 0 ? gulp.parallel(pluginsSASSTasks) : function(done) { done(); });

// Call all plugins js tasks
gulp.task('plugins-js', Object.keys(pluginsJSTasks).length !== 0 ? gulp.parallel(pluginsJSTasks) : function(done) { done(); });

var themePlugins = [
    'core',
    'instagram-feed',
    'twitter-feed'
];

var themePluginsJSTasks = [];
var themePluginsSASSTasks = [];
var themePluginsJSSources = [];
var themePluginsSASSDefaultSources = [];
var themePluginsSASSResponsiveSources = [];
themePlugins.forEach(function (name) {
    themePluginsJSTasks.push(name + '-js');
    themePluginsSASSTasks.push(name + '-sass');
});

// Concatenate theme plugins js and scss files
themePlugins.forEach(function (name) {
    themePluginsJSSources.push('../../../../plugins/solene-' + name + '/assets/js/*.js');
    themePluginsSASSDefaultSources.push('../../../../plugins/solene-' + name + '/assets/css/*-map.css');
    themePluginsSASSResponsiveSources.push('../../../../plugins/solene-' + name + '/assets/css/*-map-responsive.css');

    gulp.task(name + '-js', function () {
        return gulp.src([
            '../../../../plugins/solene-' + name + '/**/assets/js/modules/*.js',
            '!../../../../plugins/solene-core/core-dashboard/assets/js/modules/*.js'
        ])
            .pipe(concat(name + '.js'))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/js'));
    });

    gulp.task(name + '-sass', function () {
        return gulp.src('../../../../plugins/solene-' + name + '/assets/css/scss/*.scss')
            .pipe(sourcemaps.init({loadMaps: true}))
            .pipe(sassGlob())
            .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
            .pipe(autoprefixer({
                overrideBrowserslist: ['last 3 versions'],
                cascade: false
            }))
            .pipe(sourcemaps.write('../../../../plugins/solene-' + name + '/assets/css'))
            .pipe(gulp.dest('../../../../plugins/solene-' + name + '/assets/css'));
    });
});

// Call all theme plugins js tasks
gulp.task('theme-plugins-js', gulp.parallel(themePluginsJSTasks));

// Call all theme plugins sass tasks
gulp.task('theme-plugins-sass', gulp.parallel(themePluginsSASSTasks));

// Concatenate theme js files
gulp.task('theme-modules-js', function () {
    return gulp.src([
        '../../framework/modules/**/assets/js/*.js'
    ])
        .pipe(concat('theme-modules-js.js'))
        .pipe(gulp.dest(function (file) {
            var fileBase = file.cwd;
            fileBase = fileBase.replace('gulp', 'js\\modules\\theme-modules');

            return fileBase;
        }));
});

// Concatenate theme js files and minify it
gulp.task('js', gulp.series('theme-modules-js', 'theme-plugins-js', function () {
    themePluginsJSSources.unshift('../js/modules/*.js', '../js/modules/theme-modules/*.js');

    return gulp.src(themePluginsJSSources)
        .pipe(concat('modules.js'))
        .pipe(gulp.dest('../js'))
        .pipe(uglify())
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('../js'));
}));

// Concatenate theme js files
gulp.task('theme-modules-sass', function () {
    return gulp.src([
        '../../framework/modules/**/assets/css/scss/*.scss',
        '!../../framework/modules/woocommerce{,/**}'
    ])
        .pipe(sourcemaps.init({loadMaps: true}))
        .pipe(sassGlob())
        .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
        .pipe(autoprefixer({
            overrideBrowserslist: ['last 3 versions'],
            cascade: false
        }))
        .pipe(sourcemaps.write('.', {
            includeContent: false,
            sourceRoot: function (file) {
                return '../css';
            }
        }))
        .pipe(rename(function (file) {
            // this removes the last parent directory of the relative file path
            file.dirname = path.dirname(file.dirname);
        }))
        .pipe(gulp.dest('../../framework/modules'));
});

// Compile Theme Sass
gulp.task('sass', function () {
    return gulp.src('../css/scss/*.scss')
        .pipe(sourcemaps.init({loadMaps: true}))
        .pipe(sassGlob())
        .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
        .pipe(autoprefixer({
            overrideBrowserslist: ['last 3 versions'],
            cascade: false
        }))
        .pipe(sourcemaps.write('../css'))
        .pipe(gulp.dest('../css'))
        .pipe(browserSync.stream({match: '**/*.css'}));
});

// Compile Admin Sass
gulp.task('sass-admin', function () {
    return gulp.src('../../framework/admin/assets/css/scss/*.scss')
        .pipe(sassGlob())
        .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
        .pipe(gulp.dest('../../framework/admin/assets/css'));
});

//Concate default core, header and theme css files
gulp.task('concat-modules-css', gulp.series('sass', gulp.parallel('sass-admin', 'theme-plugins-sass', 'theme-modules-sass'), function () {
    themePluginsSASSDefaultSources.unshift('../css/modules.css', '../../framework/modules/**/assets/css/*-map.css');

    return gulp.src(themePluginsSASSDefaultSources)
        .pipe(concatCss('../css/modules.css'))
        .pipe(gulp.dest('../css'));
}));

//Concate responsive core, header and theme css files
gulp.task('concat-modules-css-responsive', function () {
    themePluginsSASSResponsiveSources.unshift('../css/modules-responsive.css', '../../framework/modules/**/assets/css/*-map-responsive.css');

    return gulp.src(themePluginsSASSResponsiveSources)
        .pipe(concatCss('../css/modules-responsive.css'))
        .pipe(gulp.dest('../css'));
});

// Compile Woo Sass
gulp.task('woo-sass', function () {
    return gulp.src('../../framework/modules/woocommerce/assets/css/scss/*.scss')
        .pipe(sourcemaps.init({loadMaps: true}))
        .pipe(sassGlob())
        .pipe(sass({outputStyle: 'expanded'}).on('error', sass.logError))
        .pipe(autoprefixer({
            overrideBrowserslist: ['last 3 versions'],
            cascade: false
        }))
        .pipe(sourcemaps.write('../css'))
        .pipe(gulp.dest('../css'));
});

//Minify css files
gulp.task('minifycss', gulp.series('concat-modules-css', gulp.parallel('concat-modules-css-responsive', 'woo-sass', 'plugins-sass'), function () {
    return gulp.src([
            '../css/modules.css',
            '../css/modules-responsive.css',
            '../css/woocommerce.css',
            '../css/woocommerce-responsive.css'
        ])
        .pipe(cssmin())
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('../css'))
        .pipe(browserSync.stream());
}));

// Minify JS
gulp.task('minifyjs', gulp.parallel('js', 'plugins-js'));

// Minify Files
gulp.task('minify', gulp.parallel('minifyjs', 'minifycss'));

// Watch Files For Changes
gulp.task('watch', function () {
    gulp.watch([
        '../../../../plugins/solene-*/**/assets/css/scss/**/*.scss',
        '../../framework/modules/**/assets/css/scss/**/*.scss',
        '../../framework/modules/**/admin/admin-assets/css/scss/**/*.scss',
        '../css/scss/**/*.scss'
    ], gulp.series('minifycss'));
    gulp.watch([
        '../../../../plugins/solene-*/**/assets/js/modules/*.js',
        '../../framework/modules/**/assets/js/*.js',
        '../js/modules/*.js',
        '!../../../../plugins/solene-core/core-dashboard/assets/js/modules/*.js'
    ], gulp.series('minifyjs'));
});

// Watch with browser sync
gulp.task('dev', function () {
    browserSync.init({
        proxy: 'solene.dzo'
    });

    gulp.watch([
        '../../../../plugins/solene-*/**/assets/css/scss/**/*.scss',
        '../../framework/modules/**/assets/css/scss/**/*.scss',
        '../css/scss/**/*.scss'
    ], gulp.series('minifycss'));
    gulp.watch([
        '../../../../plugins/solene-*/**/assets/js/modules/*.js',
        '../../framework/modules/**/assets/js/*.js',
        '../js/modules/*.js',
        '!../../../../plugins/solene-core/core-dashboard/assets/js/modules/*.js'
    ], gulp.series('minifyjs'));
});

// Lint Task
gulp.task('lint', function () {
    return gulp.src([
            '../js/modules.js'
        ])
        .pipe(jshint())
        .pipe(jshint.reporter('js'));
});