<?php

if ( ! function_exists( 'solene_elated_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function solene_elated_reset_options_map() {
		
		solene_elated_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'solene' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = solene_elated_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'solene' )
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'solene' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'solene' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'solene_elated_action_options_map', 'solene_elated_reset_options_map', solene_elated_set_options_map_position( 'reset' ) );
}