<?php

if ( ! function_exists( 'solene_elated_map_post_audio_meta' ) ) {
	function solene_elated_map_post_audio_meta() {
		$audio_post_format_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'solene' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'solene' ),
				'description'   => esc_html__( 'Choose audio type', 'solene' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'solene' ),
					'self'            => esc_html__( 'Self Hosted', 'solene' )
				)
			)
		);
		
		$eltdf_audio_embedded_container = solene_elated_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'eltdf_audio_embedded_container'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'solene' ),
				'description' => esc_html__( 'Enter audio URL', 'solene' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'solene' ),
				'description' => esc_html__( 'Enter audio link', 'solene' ),
				'parent'      => $eltdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_post_audio_meta', 23 );
}