<?php

if ( ! function_exists( 'solene_elated_map_post_video_meta' ) ) {
	function solene_elated_map_post_video_meta() {
		$video_post_format_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'solene' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'solene' ),
				'description'   => esc_html__( 'Choose video type', 'solene' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'solene' ),
					'self'            => esc_html__( 'Self Hosted', 'solene' )
				)
			)
		);
		
		$eltdf_video_embedded_container = solene_elated_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'eltdf_video_embedded_container'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'solene' ),
				'description' => esc_html__( 'Enter Video URL', 'solene' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'solene' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'solene' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'solene' ),
				'description' => esc_html__( 'Enter video image', 'solene' ),
				'parent'      => $eltdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'eltdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_post_video_meta', 22 );
}