<?php

/*** Post Settings ***/

if ( ! function_exists( 'solene_elated_map_post_meta' ) ) {
	function solene_elated_map_post_meta() {
		
		$post_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'solene' ),
				'name'  => 'post-meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'solene' ),
				'parent'        => $post_meta_box,
				'options'       => solene_elated_get_yes_no_select_array()
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'solene' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'solene' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => solene_elated_get_custom_sidebars_options( true )
			)
		);
		
		$solene_custom_sidebars = solene_elated_get_custom_sidebars();
		if ( count( $solene_custom_sidebars ) > 0 ) {
			solene_elated_create_meta_box_field( array(
				'name'        => 'eltdf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'solene' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'solene' ),
				'parent'      => $post_meta_box,
				'options'     => solene_elated_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'solene' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'solene' ),
				'parent'      => $post_meta_box
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_centered_content_on_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Center content on Post Single', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will center content on post single', 'solene' ),
				'options'       => solene_elated_get_yes_no_select_array(),
				'parent'        => $post_meta_box
			)
		);

		do_action('solene_elated_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_post_meta', 20 );
}
