<?php
class SoleneElatedElementorBlogSlider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_blog_slider'; 
	}

	public function get_title() {
		return esc_html__( 'Blog Slider', 'solene' );
	}

	public function get_icon() {
		return 'solene-elementor-custom-icon solene-elementor-blog-slider';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'solene' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label'     => esc_html__( 'Type', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'slider' => esc_html__( 'Slider', 'solene'),
					'carousel' => esc_html__( 'Carousel', 'solene'),
					'carousel-centered' => esc_html__( 'Carousel Centered', 'solene')
				),
				'default' => 'slider'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'solene' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'solene'),
					'ID' => esc_html__( 'ID', 'solene'),
					'menu_order' => esc_html__( 'Menu Order', 'solene'),
					'name' => esc_html__( 'Post Name', 'solene'),
					'rand' => esc_html__( 'Random', 'solene'),
					'title' => esc_html__( 'Title', 'solene')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'solene'),
					'DESC' => esc_html__( 'DESC', 'solene')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'solene' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'solene' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'full' => esc_html__( 'Original', 'solene'),
					'solene_elated_image_square' => esc_html__( 'Square', 'solene'),
					'solene_elated_image_landscape' => esc_html__( 'Landscape', 'solene'),
					'solene_elated_image_portrait' => esc_html__( 'Portrait', 'solene'),
					'thumbnail' => esc_html__( 'Thumbnail', 'solene'),
					'medium' => esc_html__( 'Medium', 'solene'),
					'large' => esc_html__( 'Large', 'solene'),
					'custom' => esc_html__( 'Custom', 'solene')
				),
				'default' => 'full'
			]
		);

		$this->add_control(
			'custom_image_width',
			[
				'label'     => esc_html__( 'Custom Image Width', 'solene' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image width in px', 'solene' ),
				'condition' => [
					'image_size' => array( 'custom' )
				]
			]
		);

		$this->add_control(
			'custom_image_height',
			[
				'label'     => esc_html__( 'Custom Image Height', 'solene' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image height in px', 'solene' ),
				'condition' => [
					'image_size' => array( 'custom' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_info',
			[
				'label' => esc_html__( 'Post Info', 'solene' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'solene'),
					'h1' => esc_html__( 'h1', 'solene'),
					'h2' => esc_html__( 'h2', 'solene'),
					'h3' => esc_html__( 'h3', 'solene'),
					'h4' => esc_html__( 'h4', 'solene'),
					'h5' => esc_html__( 'h5', 'solene'),
					'h6' => esc_html__( 'h6', 'solene')
				),
				'default' => 'h2'
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'solene'),
					'none' => esc_html__( 'None', 'solene'),
					'capitalize' => esc_html__( 'Capitalize', 'solene'),
					'uppercase' => esc_html__( 'Uppercase', 'solene'),
					'lowercase' => esc_html__( 'Lowercase', 'solene'),
					'initial' => esc_html__( 'Initial', 'solene'),
					'inherit' => esc_html__( 'Inherit', 'solene')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'post_info_author',
			[
				'label'     => esc_html__( 'Enable Post Info Author', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'solene'),
					'no' => esc_html__( 'No', 'solene')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_date',
			[
				'label'     => esc_html__( 'Enable Post Info Date', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'solene'),
					'no' => esc_html__( 'No', 'solene')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_category',
			[
				'label'     => esc_html__( 'Enable Post Info Category', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'solene'),
					'no' => esc_html__( 'No', 'solene')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_comments',
			[
				'label'     => esc_html__( 'Enable Post Info Comments', 'solene' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'solene'),
					'yes' => esc_html__( 'Yes', 'solene')
				),
				'default' => 'no'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$queryArray             = $this->generateBlogQueryArray( $params );
		$query_result           = new \WP_Query( $queryArray );
		$params['query_result'] = $query_result;
		
		$params['slider_type']    = ! empty( $params['slider_type'] ) ? $params['slider_type'] : 'slider';
		$params['slider_classes'] = $this->getSliderClasses( $params );
		$params['slider_data']    = $this->getSliderData( $params );
		
		ob_start();
		
		solene_elated_get_module_template_part( 'shortcodes/blog-slider/holder', 'blog', '', $params );
		
		$html = ob_get_contents();
		
		ob_end_clean();
		
		echo solene_elated_get_module_part($html);
	}

	public function generateBlogQueryArray( $params ) {
		$queryArray = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'orderby'        => $params['orderby'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'post__not_in'   => get_option( 'sticky_posts' )
		);
		
		if ( ! empty( $params['category'] ) ) {
			$queryArray['category_name'] = $params['category'];
		}
		
		return $queryArray;
	}

	public function getSliderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = 'eltdf-bs-' . $params['slider_type'];
		
		return implode( ' ', $holderClasses );
	}

	private function getSliderData( $params ) {
		$type        = $params['slider_type'];
		$slider_data = array();
		
		if($type == 'carousel') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '80';
			$slider_data['data-slider-padding']    = 'yes';
			$slider_data['data-enable-navigation'] = 'no';
		} else if ($type == 'carousel-centered') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '30';
			$slider_data['data-enable-center']     = 'yes';
			$slider_data['data-enable-navigation'] = 'yes';
			$slider_data['data-enable-pagination'] = 'yes';
		} else {
			$slider_data['data-number-of-items']   = '1';
			$slider_data['data-enable-pagination'] = 'yes';
		}
		
		return $slider_data;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SoleneElatedElementorBlogSlider() );