<?php

if ( ! function_exists( 'solene_elated_include_blog_shortcodes' ) ) {
	function solene_elated_include_blog_shortcodes() {
        if( solene_elated_is_theme_registered() ) {
            foreach ( glob( SOLENE_ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/load.php' ) as $shortcode_load ) {
                include_once $shortcode_load;
            }
        }
	}
	
	if ( solene_elated_is_plugin_installed( 'core' ) ) {
		add_action( 'solene_core_action_include_shortcodes_file', 'solene_elated_include_blog_shortcodes' );
	}
}

// Load woo elementor widgets
if ( ! function_exists( 'solene_elated_include_blog_elementor_widgets_files' ) ) {
    /**
     * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
     */
    function solene_elated_include_blog_elementor_widgets_files() {
        if ( solene_elated_is_plugin_installed('core') && solene_elated_is_theme_registered() ) {
            foreach (glob(SOLENE_ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/elementor-*.php') as $shortcode_load) {
                include_once $shortcode_load;
            }
        }
    }
    if ( solene_elated_is_plugin_installed('elementor') && solene_elated_is_plugin_installed( 'core' ) ) {
        add_action('elementor/widgets/widgets_registered', 'solene_elated_include_blog_elementor_widgets_files');
    }
}