<?php if ( $max_num_pages > 1 ) { ?>
	<div class="eltdf-blog-pag-loading">
		<div class="eltdf-blog-pag-bounce1"></div>
		<div class="eltdf-blog-pag-bounce2"></div>
		<div class="eltdf-blog-pag-bounce3"></div>
	</div>
	<?php
	$number_of_pages = $max_num_pages;
	$current_page    = $paged;
	
	if ( $number_of_pages > 1 ) { ?>
		<div class="eltdf-bl-standard-pagination">
			<ul>
				<li class="eltdf-pag-prev">
					<a href="#" data-paged="1"><span class="eltdf-arrow-left"><?php echo solene_elated_return_svg_arrow_left(); ?></span></a>
				</li>
				<?php for ( $i = 1; $i <= $number_of_pages; $i ++ ) { ?>
					<?php
					$link_classes = '';
					if ( $current_page == $i ) {
						$link_classes = 'eltdf-pag-active';
					}
					?>
					<li class="eltdf-pag-number <?php echo esc_attr( $link_classes ); ?>">
						<a href="#" data-paged="<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></a>
						<span><?php echo solene_elated_return_svg_pagination_icon();?></span>
					</li>
				<?php } ?>
				<li class="eltdf-pag-next">
					<a href="#" data-paged="2"><span class="eltdf-arrow-right"><?php echo solene_elated_return_svg_arrow_right(); ?></span></a>
				</li>
			</ul>
		</div>
	<?php }
	
	$unique_id = rand( 1000, 9999 );
	wp_nonce_field( 'eltdf_blog_load_more_nonce_' . $unique_id, 'eltdf_blog_load_more_nonce_' . $unique_id );
} ?>
