<?php
$blog_single_navigation = solene_elated_options()->getOptionValue('blog_single_navigation') === 'no' ? false : true;
$blog_navigation_through_same_category = solene_elated_options()->getOptionValue('blog_navigation_through_same_category') === 'no' ? false : true;
?>
<?php if($blog_single_navigation){ ?>
	<div class="eltdf-blog-single-navigation">
		<div class="eltdf-blog-single-navigation-inner clearfix">
			<?php
				/* Single navigation section - SETTING PARAMS */
				$post_navigation = array(
					'prev' => array(
						'mark_open' => '<span class="eltdf-blog-single-nav-mark eltdf-arrow-left">',
						'mark_close' => '</span>',
						'label' => '<span class="eltdf-blog-single-nav-label">'.esc_html__('prev', 'solene').'</span>'
					),
					'next' => array(
						'mark_open' => '<span class="eltdf-blog-single-nav-mark eltdf-arrow-right">',
						'mark_close' => '</span>',
						'label' => '<span class="eltdf-blog-single-nav-label">'.esc_html__('next', 'solene').'</span>'
					)
				);
			
				if($blog_navigation_through_same_category){
					if(get_previous_post(true) !== ""){
						$post_navigation['prev']['post'] = get_previous_post(true);
					}
					if(get_next_post(true) !== ""){
						$post_navigation['next']['post'] = get_next_post(true);
					}
				} else {
					if(get_previous_post() !== ""){
						$post_navigation['prev']['post'] = get_previous_post();
					}
					if(get_next_post() !== ""){
						$post_navigation['next']['post'] = get_next_post();
					}
				}

				/* Single navigation section - RENDERING */
				foreach (array('prev', 'next') as $nav_type) {
					if (isset($post_navigation[$nav_type]['post'])) {
						$svg_icon = $nav_type === 'prev' ? solene_elated_return_svg_arrow_left() : solene_elated_return_svg_arrow_right();
						?>
						<a itemprop="url" class="eltdf-blog-single-<?php echo esc_attr( $nav_type ); ?>" href="<?php echo get_permalink( $post_navigation[ $nav_type ]['post']->ID ); ?>">
							<?php echo sprintf( '%s%s%s', $post_navigation[ $nav_type ]['mark_open'], $svg_icon, $post_navigation[ $nav_type ]['mark_close'] ); ?>
							<?php echo wp_kses( $post_navigation[ $nav_type ]['label'], array( 'span' => array( 'class' => true ) ) ); ?>
						</a>
					<?php }
				}
			?>
		</div>
	</div>
<?php } ?>