<?php

if ( ! function_exists( 'solene_elated_footer_options_map' ) ) {
	function solene_elated_footer_options_map() {

		solene_elated_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'solene' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = solene_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'solene' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'solene' ),
				'parent'        => $footer_panel
			)
		);

        solene_elated_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'solene' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'solene' ),
                'parent'        => $footer_panel
            )
        );

		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'solene' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = solene_elated_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'solene' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'solene' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => '',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'solene' ),
				'description'   => esc_html__( 'Text Alignment in Footer Top Columns', 'solene' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'solene' ),
					'left'   => esc_html__( 'Left', 'solene' ),
					'center' => esc_html__( 'Center', 'solene' ),
					'right'  => esc_html__( 'Right', 'solene' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = solene_elated_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'solene' ),
				'description' => esc_html__( 'Define style for footer top area', 'solene' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = solene_elated_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'solene' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'solene' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'solene' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'solene' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = solene_elated_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'solene' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'solene' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns_alignment',
				'default_value' => '',
				'label'         => esc_html__( 'Footer Bottom Columns Alignment', 'solene' ),
				'description'   => esc_html__( 'Text Alignment in Footer Bottom Columns', 'solene' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'solene' ),
					'left'   => esc_html__( 'Left', 'solene' ),
					'center' => esc_html__( 'Center', 'solene' ),
					'right'  => esc_html__( 'Right', 'solene' )
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = solene_elated_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'solene' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'solene' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = solene_elated_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'solene' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'solene' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			solene_elated_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'solene' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'solene_elated_action_options_map', 'solene_elated_footer_options_map', solene_elated_set_options_map_position( 'footer' ) );
}