<?php

if ( ! function_exists( 'solene_elated_mobile_menu_meta_box_map' ) ) {
	function solene_elated_mobile_menu_meta_box_map($header_meta_box) {

		solene_elated_add_admin_section_title(
			array(
				'parent' => $header_meta_box,
				'name'   => 'header_mobile',
				'title'  => esc_html__( 'Mobile Header in Grid', 'solene' )
			)
		);

		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_mobile_header_in_grid_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Mobile Header in Grid', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will put mobile header in grid', 'solene' ),
				'parent'        => $header_meta_box,
				'options'       => solene_elated_get_yes_no_select_array()
			)
		);

		$mobile_header_without_grid_container = solene_elated_add_admin_container(
			array(
				'parent'          => $header_meta_box,
				'name'            => 'mobile_header_without_grid_container',
				'dependency' => array(
					'show' => array(
						'eltdf_mobile_header_in_grid_meta' => 'no'
					)
				)
			)
		);

		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_mobile_header_without_grid_padding_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Mobile Header Padding', 'solene' ),
				'description' => esc_html__( 'Set padding for Mobile Header', 'solene' ),
				'parent'      => $mobile_header_without_grid_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);


	}
	
	add_action( 'solene_elated_action_header_mobile_menu_meta_boxes_map', 'solene_elated_mobile_menu_meta_box_map', 10 );
}