<?php

if ( ! function_exists( 'solene_elated_logo_options_map' ) ) {
	function solene_elated_logo_options_map() {
		
		solene_elated_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'solene' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = solene_elated_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'solene' )
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'solene' )
			)
		);
		
		$hide_logo_container = solene_elated_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => SOLENE_ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'solene' ),
				'parent'        => $hide_logo_container
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => SOLENE_ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'solene' ),
				'parent'        => $hide_logo_container
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => SOLENE_ELATED_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'solene' ),
				'parent'        => $hide_logo_container
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => SOLENE_ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'solene' ),
				'parent'        => $hide_logo_container
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => SOLENE_ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'solene' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'solene_elated_action_options_map', 'solene_elated_logo_options_map', solene_elated_set_options_map_position( 'logo' ) );
}