<?php

if ( ! function_exists( 'solene_elated_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function solene_elated_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'solene_elated_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'solene_elated_header_standard_meta_map' ) ) {
	function solene_elated_header_standard_meta_map( $parent ) {
		$hide_dep_options = solene_elated_get_hide_dep_for_header_standard_meta_boxes();
		
		solene_elated_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'eltdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'solene' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'solene' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'solene' ),
					'left'   => esc_html__( 'Left', 'solene' ),
					'right'  => esc_html__( 'Right', 'solene' ),
					'center' => esc_html__( 'Center', 'solene' )
				),
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'solene_elated_action_additional_header_area_meta_boxes_map', 'solene_elated_header_standard_meta_map' );
}