<?php

if ( ! function_exists( 'solene_elated_sidearea_options_map' ) ) {
	function solene_elated_sidearea_options_map() {

        solene_elated_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'solene'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = solene_elated_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'solene'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'solene'),
                'description'   => esc_html__('Choose a type of Side Area', 'solene'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'solene'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'solene'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'solene'),
                ),
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'solene'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'solene'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = solene_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'solene'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'solene'),
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'solene'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'solene'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'icon_pack',
                'label'         => esc_html__('Select Side Area Icon Source', 'solene'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'solene'),
                'options'       => solene_elated_get_icon_sources_array()
            )
        );

        $side_area_icon_pack_container = solene_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'font_elegant',
                'label'         => esc_html__('Side Area Icon Pack', 'solene'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'solene'),
                'options'       => solene_elated_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = solene_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'solene'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'solene'),
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'solene'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'solene'),
            )
        );

        $side_area_icon_style_group = solene_elated_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'solene'),
                'description' => esc_html__('Define styles for Side Area icon', 'solene')
            )
        );

        $side_area_icon_style_row1 = solene_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'solene')
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'solene')
            )
        );

        $side_area_icon_style_row2 = solene_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'solene')
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'solene')
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'solene'),
                'description' => esc_html__('Choose a background color for Side Area', 'solene')
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'solene'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'solene'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        solene_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'solene'),
                'description'   => esc_html__('Choose text alignment for side area', 'solene'),
                'options'       => array(
                    ''       => esc_html__('Default', 'solene'),
                    'left'   => esc_html__('Left', 'solene'),
                    'center' => esc_html__('Center', 'solene'),
                    'right'  => esc_html__('Right', 'solene')
                )
            )
        );
    }

    add_action('solene_elated_action_options_map', 'solene_elated_sidearea_options_map', solene_elated_set_options_map_position( 'sidearea' ) );
}