<?php

if ( ! function_exists( 'solene_elated_register_side_area_sidebar' ) ) {
	/**
	 * Register side area sidebar
	 */
	function solene_elated_register_side_area_sidebar() {
		register_sidebar(
			array(
				'id'            => 'sidearea',
				'name'          => esc_html__( 'Side Area', 'solene' ),
				'description'   => esc_html__( 'Side Area', 'solene' ),
				'before_widget' => '<div id="%1$s" class="widget eltdf-sidearea %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="eltdf-widget-title-holder"><h5 class="eltdf-widget-title">',
				'after_title'   => '</h5></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'solene_elated_register_side_area_sidebar' );
}

if ( ! function_exists( 'solene_elated_side_menu_body_class' ) ) {
	/**
	 * Function that adds body classes for different side menu styles
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function solene_elated_side_menu_body_class( $classes ) {
		
		if ( is_active_widget( false, false, 'eltdf_side_area_opener' ) ) {
			
			if ( solene_elated_options()->getOptionValue( 'side_area_type' ) ) {
				$classes[] = 'eltdf-' . solene_elated_options()->getOptionValue( 'side_area_type' );
			}
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'solene_elated_side_menu_body_class' );
}

if ( ! function_exists( 'solene_elated_get_side_area' ) ) {
	/**
	 * Loads side area HTML
	 */
	function solene_elated_get_side_area() {
		
		if ( is_active_widget( false, false, 'eltdf_side_area_opener' ) ) {
			$parameters = array(
				'close_icon_classes' => solene_elated_get_side_area_close_icon_class()
			);
			
			solene_elated_get_module_template_part( 'templates/sidearea', 'sidearea', '', $parameters );
		}
	}
	
	add_action( 'solene_elated_action_before_closing_body_tag', 'solene_elated_get_side_area', 10 );
}

if ( ! function_exists( 'solene_elated_get_side_area_close_class' ) ) {
	/**
	 * Loads side area close icon class
	 */
	function solene_elated_get_side_area_close_icon_class() {
		$classes = array(
			'eltdf-close-side-menu'
		);
		
		$classes[] = solene_elated_get_icon_sources_class( 'side_area', 'eltdf-close-side-menu' );
		
		return $classes;
	}
}