<?php

if ( ! function_exists( 'solene_elated_map_sidebar_meta' ) ) {
	function solene_elated_map_sidebar_meta() {
		$eltdf_sidebar_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'solene_elated_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'solene' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'solene' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'solene' ),
				'parent'      => $eltdf_sidebar_meta_box,
                'options'       => solene_elated_get_custom_sidebars_options( true )
			)
		);
		
		$eltdf_text_sidebar_meta_box = solene_elated_create_meta_box (
			array(
				'scope' => apply_filters( 'solene_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ) ),
				'title' => esc_html__( 'Left/Right Side Text Sidebars', 'solene' ),
				'name'  => 'sidebar_text_meta'
			)
		);
		
		$eltdf_custom_sidebars = solene_elated_get_custom_sidebars();
		if ( count( $eltdf_custom_sidebars ) > 0 ) {
			solene_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'solene' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'solene' ),
					'parent'      => $eltdf_sidebar_meta_box,
					'options'     => $eltdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
			
			solene_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_left_text_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Left Side Text', 'solene' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Left Side Text Sidebar"', 'solene' ),
					'parent'      => $eltdf_text_sidebar_meta_box,
					'options'     => $eltdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
			
			solene_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_right_text_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Right Side Text', 'solene' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Right Side Text Sidebar', 'solene' ),
					'parent'      => $eltdf_text_sidebar_meta_box,
					'options'     => $eltdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
		solene_elated_create_meta_box_field(
			array(
				'name'   => 'eltdf_custom_text_sidebar_offset_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Sidebars Bottom Offset', 'solene' ),
				'parent' => $eltdf_text_sidebar_meta_box,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => 'px'
				)
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'   => 'eltdf_custom_text_sidebar_offset_small_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Sidebars Bottom Offset Bellow Laptops', 'solene' ),
				'description' => esc_html__( 'Sidebars Bottom Offset Bellow Laptops Screen Size', 'solene' ),
				'parent' => $eltdf_text_sidebar_meta_box,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => 'px'
				)
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_left_text_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Left Side Text', 'solene' ),
				'parent'        => $eltdf_text_sidebar_meta_box
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_right_text_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Right Side Text', 'solene' ),
				'parent'        => $eltdf_text_sidebar_meta_box
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_mac_responsive_text_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Pre-defined screen position for Laptops', 'solene' ),
				'parent'        => $eltdf_text_sidebar_meta_box
			)
		);
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_sidebar_meta', 31 );
}