<?php

if ( ! function_exists( 'solene_elated_sidebar_options_map' ) ) {
	function solene_elated_sidebar_options_map() {
		
		solene_elated_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'solene' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = solene_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'solene' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		solene_elated_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'solene' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'solene' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => solene_elated_get_custom_sidebars_options()
		) );
		
		$solene_custom_sidebars = solene_elated_get_custom_sidebars();
		if ( count( $solene_custom_sidebars ) > 0 ) {
			solene_elated_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'solene' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'solene' ),
				'parent'      => $sidebar_panel,
				'options'     => $solene_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'solene_elated_action_options_map', 'solene_elated_sidebar_options_map', solene_elated_set_options_map_position( 'sidebar' ) );
}