<?php

if ( ! function_exists( 'solene_elated_sidebar_layout' ) ) {
	/**
	 * Function that check is sidebar is enabled and return type of sidebar layout
	 */
	function solene_elated_sidebar_layout() {
		$sidebar_layout         = '';
		$sidebar_layout_meta    = solene_elated_get_meta_field_intersect( 'sidebar_layout' );
		$archive_sidebar_layout = solene_elated_options()->getOptionValue( 'archive_sidebar_layout' );
		$search_sidebar_layout  = solene_elated_options()->getOptionValue( 'search_page_sidebar_layout' );
		$single_sidebar_layout  = solene_elated_get_meta_field_intersect( 'blog_single_sidebar_layout' );
		
		if ( ! empty( $sidebar_layout_meta ) ) {
			$sidebar_layout = $sidebar_layout_meta;
		}
		
		if ( is_singular( 'post' ) && ! empty( $single_sidebar_layout ) ) {
			$sidebar_layout = $single_sidebar_layout;
		}
		
		if ( is_search() && ! solene_elated_is_woocommerce_shop() && ! empty( $search_sidebar_layout ) ) {
			$sidebar_layout = $search_sidebar_layout;
		}
		
		if ( ( is_archive() || ( is_home() && is_front_page() ) ) && ! solene_elated_is_woocommerce_page() && ! empty( $archive_sidebar_layout ) ) {
			$sidebar_layout = $archive_sidebar_layout;
		}
		
		if ( ! empty( $sidebar_layout ) && ! is_active_sidebar( solene_elated_get_sidebar() ) ) {
			$sidebar_layout = '';
		}
		
		return apply_filters( 'solene_elated_filter_sidebar_layout', $sidebar_layout );
	}
}

if ( ! function_exists( 'solene_elated_get_content_sidebar_class' ) ) {
	/**
	 * Return classes for content holder when sidebar is active
	 *
	 * @return string
	 */
	function solene_elated_get_content_sidebar_class() {
		$sidebar_layout = solene_elated_sidebar_layout();
		$content_class  = array( 'eltdf-page-content-holder' );
		
		switch ( $sidebar_layout ) {
			case 'sidebar-33-right':
				$content_class[] = 'eltdf-grid-col-8';
				break;
			case 'sidebar-25-right':
				$content_class[] = 'eltdf-grid-col-9';
				break;
            case 'sidebar-20-right':
                $content_class[] = 'eltdf-grid-col-10';
                break;
			case 'sidebar-33-left':
				$content_class[] = 'eltdf-grid-col-8';
				$content_class[] = 'eltdf-grid-col-push-4';
				break;
			case 'sidebar-25-left':
				$content_class[] = 'eltdf-grid-col-9';
				$content_class[] = 'eltdf-grid-col-push-3';
				break;
            case 'sidebar-20-left':
                $content_class[] = 'eltdf-grid-col-10';
                $content_class[] = 'eltdf-grid-col-push-2';
                break;
			default:
				$content_class[] = 'eltdf-grid-col-12';
				break;
		}
		
		return solene_elated_get_class_attribute( $content_class );
	}
}

if ( ! function_exists( 'solene_elated_get_sidebar_holder_class' ) ) {
	/**
	 * Return classes for sidebar holder when sidebar is active
	 *
	 * @return string
	 */
	function solene_elated_get_sidebar_holder_class() {
		$sidebar_layout = solene_elated_sidebar_layout();
		$sidebar_class  = array( 'eltdf-sidebar-holder' );
		
		switch ( $sidebar_layout ) {
			case 'sidebar-33-right':
				$sidebar_class[] = 'eltdf-grid-col-4';
				break;
			case 'sidebar-25-right':
				$sidebar_class[] = 'eltdf-grid-col-3';
				break;
            case 'sidebar-20-right':
                $sidebar_class[] = 'eltdf-grid-col-2';
                break;
			case 'sidebar-33-left':
				$sidebar_class[] = 'eltdf-grid-col-4';
				$sidebar_class[] = 'eltdf-grid-col-pull-8';
				break;
			case 'sidebar-25-left':
				$sidebar_class[] = 'eltdf-grid-col-3';
				$sidebar_class[] = 'eltdf-grid-col-pull-9';
				break;
            case 'sidebar-20-left':
                $sidebar_class[] = 'eltdf-grid-col-2';
                $sidebar_class[] = 'eltdf-grid-col-pull-10';
		}
		
		return solene_elated_get_class_attribute( $sidebar_class );
	}
}

if ( ! function_exists( 'solene_elated_get_sidebar' ) ) {
	/**
	 * Return Sidebar name
	 *
	 * @return string
	 */
	function solene_elated_get_sidebar() {
		$sidebar_name                = 'sidebar';
		$custom_sidebar_area         = solene_elated_get_meta_field_intersect( 'custom_sidebar_area' );
		$custom_archive_sidebar_area = solene_elated_options()->getOptionValue( 'archive_custom_sidebar_area' );
		$custom_search_sidebar_area  = solene_elated_options()->getOptionValue( 'search_custom_sidebar_area' );
		$custom_single_sidebar_area  = solene_elated_get_meta_field_intersect( 'blog_single_custom_sidebar_area' );
		
		if ( ! empty( $custom_sidebar_area ) ) {
			$sidebar_name = $custom_sidebar_area;
		}
		
		if ( is_singular( 'post' ) && ! empty( $custom_single_sidebar_area ) ) {
			$sidebar_name = $custom_single_sidebar_area;
		}
		
		if ( is_search() && ! empty( $custom_search_sidebar_area ) ) {
			$sidebar_name = $custom_search_sidebar_area;
		}
		
		if ( ( is_archive() || ( is_home() && is_front_page() ) ) && ! solene_elated_is_woocommerce_page() && ! empty( $custom_archive_sidebar_area ) ) {
			$sidebar_name = $custom_archive_sidebar_area;
		}
		
		return apply_filters( 'solene_elated_filter_sidebar_name', $sidebar_name );
	}
}

if ( ! function_exists( 'solene_elated_get_custom_sidebars' ) ) {
	/**
	 * Function that returns all custom made sidebars.
	 *
	 * @uses get_option()
	 * @return array array of custom made sidebars where key and value are sidebar name
	 */
	function solene_elated_get_custom_sidebars() {
		$solene_custom_sidebars = get_option( 'eltdf_sidebars' );
		$formatted_array             = array();
		
		if ( is_array( $solene_custom_sidebars ) && count( $solene_custom_sidebars ) ) {
			foreach ( $solene_custom_sidebars as $custom_sidebar ) {
				$formatted_array[ sanitize_title( $custom_sidebar ) ] = $custom_sidebar;
			}
		}
		
		return $formatted_array;
	}
}

if ( ! function_exists( 'solene_elated_get_side_sidebar' ) ) {
	/**
	 * Return Sidebar name
	 *
	 * @return string
	 */
	function solene_elated_get_side_sidebar( $sidebar_name ) {
		$op_name              = 'eltdf_custom_' . esc_attr( $sidebar_name ) . '_text_sidebar_area_meta';
		$custom_sidebar_area  = get_post_meta(get_the_ID(), $op_name, true);
		$disable_sidebar      = get_post_meta(get_the_ID(), 'eltdf_disable_' . esc_attr( $sidebar_name ) . '_text_meta', true);
		$sidebar_name         = esc_attr( $sidebar_name ) . '-text';
		
		if ( ! empty( $custom_sidebar_area ) ) {
			$sidebar_name = $custom_sidebar_area;
		}
		
		if( $disable_sidebar === 'yes' ) {
			return false;
		}
		
		return apply_filters( 'solene_elated_side_sidebar_name', $sidebar_name );
	}
}

if ( ! function_exists( 'solene_elated_get_custom_sidebars_options' ) ) {
	function solene_elated_get_custom_sidebars_options( $enable_default = false ) {
		$sidebar_options = array();
		
		if ( $enable_default ) {
			$sidebar_options[''] = esc_html__( 'Default', 'solene' );
		}
		
		$sidebar_options['no-sidebar']       = esc_html__( 'No Sidebar', 'solene' );
		$sidebar_options['sidebar-33-right'] = esc_html__( 'Sidebar 1/3 Right', 'solene' );
		$sidebar_options['sidebar-25-right'] = esc_html__( 'Sidebar 1/4 Right', 'solene' );
		$sidebar_options['sidebar-20-right'] = esc_html__( 'Sidebar 1/5 Right', 'solene' );
		$sidebar_options['sidebar-33-left']  = esc_html__( 'Sidebar 1/3 Left', 'solene' );
		$sidebar_options['sidebar-25-left']  = esc_html__( 'Sidebar 1/4 Left', 'solene' );
		$sidebar_options['sidebar-20-left']  = esc_html__( 'Sidebar 1/5 Left', 'solene' );
		
		return $sidebar_options;
	}
}

if ( ! function_exists( 'solene_elated_text_sidebars_offset' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function solene_elated_text_sidebars_offset( $style ) {
		$id            = solene_elated_get_page_id();
		$class_prefix  = solene_elated_get_unique_page_class( $id );
		$offset        = get_post_meta( $id, 'eltdf_custom_text_sidebar_offset_meta', true );
		$offset_small  = get_post_meta( $id, 'eltdf_custom_text_sidebar_offset_small_meta', true );
		$res_start_mark = '@media only screen and (max-width: 1280px) {';
		$res_end_mark = '}';
		
		$selector = array(
			$class_prefix . ' .eltdf-left-side-text',
			$class_prefix . ' .eltdf-right-side-text'
		);
		
		$text_styles  = array();
		if ( '' !== $offset ) {
			$text_styles['bottom'] = solene_elated_filter_px( $offset ) . 'px';
		}
		
		$res_style  = array();
		if ( '' !== $offset_small ) {
			$res_style['bottom'] = solene_elated_filter_px( $offset_small ) . 'px';
		}
		
		$current_style = '';
		if( ! empty( $text_styles ) ) {
			$current_style .= solene_elated_dynamic_css( $selector, $text_styles );
			
		}
		
		if( ! empty( $res_style ) ) {
			$current_style .= $res_start_mark . solene_elated_dynamic_css( $selector, $res_style ) . $res_end_mark;
			
		}
		
		return $style . $current_style;
	}
	
	add_filter( 'solene_elated_filter_add_page_custom_style', 'solene_elated_text_sidebars_offset' );
}

if ( ! function_exists( 'solene_elated_text_sidebars_mac_responsive_offset' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function solene_elated_text_sidebars_mac_responsive_offset( $classes ) {
		$id             = solene_elated_get_page_id();
		$mac_responsive = get_post_meta( $id, 'eltdf_mac_responsive_text_meta', true );
		
		if ( $mac_responsive === 'yes' ) {
			$classes[] = 'eltdf-side-text-mac-style';
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'solene_elated_text_sidebars_mac_responsive_offset' );
}