<?php

if ( ! function_exists( 'solene_elated_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function solene_elated_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'solene' ),
				'description'   => esc_html__( 'Default Sidebar area. In order to display this area you need to enable it through global theme options or on page meta box options.', 'solene' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="eltdf-widget-title-holder"><h3 class="eltdf-widget-title">',
				'after_title'   => '</h3></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'solene_elated_register_sidebars', 1 );
}

if ( ! function_exists( 'solene_elated_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates SoleneElatedClassSidebar object
	 */
	function solene_elated_add_support_custom_sidebar() {
		add_theme_support( 'SoleneElatedClassSidebar' );
		
		if ( get_theme_support( 'SoleneElatedClassSidebar' ) ) {
			new SoleneElatedClassSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'solene_elated_add_support_custom_sidebar' );
}