<?php

if ( ! function_exists( 'solene_elated_get_title_types_meta_boxes' ) ) {
	function solene_elated_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'solene_elated_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'solene' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( SOLENE_ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'solene_elated_map_title_meta' ) ) {
	function solene_elated_map_title_meta() {
		$title_type_meta_boxes = solene_elated_get_title_types_meta_boxes();
		
		$title_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'solene_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'solene' ),
				'name'  => 'title_meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'solene' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'solene' ),
				'parent'        => $title_meta_box,
				'options'       => solene_elated_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = solene_elated_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'eltdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'eltdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'solene' ),
						'description'   => esc_html__( 'Choose title type', 'solene' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'solene' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'solene' ),
						'options'       => solene_elated_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'solene' ),
						'description' => esc_html__( 'Set a height for Title Area', 'solene' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_padding_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Title Padding Left/Right', 'solene' ),
						'description' => esc_html__( 'Set a padding for Title Area, type Centered', 'solene' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);

				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_height_mobile_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height on Mobile', 'solene' ),
						'description' => esc_html__( 'Set a height for Title Area on Mobile', 'solene' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'solene' ),
						'description' => esc_html__( 'Choose a background color for title area', 'solene' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'solene' ),
						'description' => esc_html__( 'Choose an Image for title area', 'solene' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'solene' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'solene' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'solene' ),
							'hide'                => esc_html__( 'Hide Image', 'solene' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'solene' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'solene' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'solene' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'solene' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'solene' )
						)
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'solene' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'solene' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'solene' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'solene' ),
							'window-top'    => esc_html__( 'From Window Top', 'solene' )
						)
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'solene' ),
						'options'       => solene_elated_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'solene' ),
						'description' => esc_html__( 'Choose a color for title text', 'solene' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'solene' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'solene' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				solene_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'solene' ),
						'options'       => solene_elated_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				solene_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'solene' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'solene' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'solene_elated_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_title_meta', 60 );
}