<?php

if ( class_exists( 'SoleneCoreClassWidget' ) ) {
	class SoleneElatedClassButtonWidget extends SoleneCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'eltdf_button_widget',
				esc_html__( 'Solene Button Widget', 'solene' ),
				array( 'description' => esc_html__( 'Add button element to widget areas', 'solene' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'solene' ),
					'options' => array(
						'solid'   => esc_html__( 'Solid', 'solene' ),
						'outline' => esc_html__( 'Outline', 'solene' ),
						'simple'  => esc_html__( 'Simple', 'solene' )
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'size',
					'title'       => esc_html__( 'Size', 'solene' ),
					'options'     => array(
						'small'  => esc_html__( 'Small', 'solene' ),
						'medium' => esc_html__( 'Medium', 'solene' ),
						'large'  => esc_html__( 'Large', 'solene' ),
						'huge'   => esc_html__( 'Huge', 'solene' )
					),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'solene' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'text',
					'title'   => esc_html__( 'Text', 'solene' ),
					'default' => esc_html__( 'Button Text', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'link',
					'title' => esc_html__( 'Link', 'solene' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'target',
					'title'   => esc_html__( 'Link Target', 'solene' ),
					'options' => solene_elated_get_link_target_array()
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'solene' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'solene' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'background_color',
					'title'       => esc_html__( 'Background Color', 'solene' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'solene' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_background_color',
					'title'       => esc_html__( 'Hover Background Color', 'solene' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'solene' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'border_color',
					'title'       => esc_html__( 'Border Color', 'solene' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'solene' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_border_color',
					'title'       => esc_html__( 'Hover Border Color', 'solene' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'solene' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'solene' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'solene' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$params = '';
			
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			// Filter out all empty params
			$instance = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );
			
			// Default values
			if ( ! isset( $instance['text'] ) ) {
				$instance['text'] = 'Button Text';
			}
			
			// Generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
			
			echo '<div class="widget eltdf-button-widget">';
			echo do_shortcode( "[eltdf_button $params]" ); // XSS OK
			echo '</div>';
		}
	}
}