<?php

if ( class_exists( 'SoleneCoreClassWidget' ) ) {
	class SoleneElatedClassSeparatorWidget extends SoleneCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'eltdf_separator_widget',
				esc_html__( 'Solene Separator Widget', 'solene' ),
				array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'solene' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'solene' ),
					'options' => array(
						'normal'     => esc_html__( 'Normal', 'solene' ),
						'full-width' => esc_html__( 'Full Width', 'solene' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'position',
					'title'   => esc_html__( 'Position', 'solene' ),
					'options' => array(
						'center' => esc_html__( 'Center', 'solene' ),
						'left'   => esc_html__( 'Left', 'solene' ),
						'right'  => esc_html__( 'Right', 'solene' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'border_style',
					'title'   => esc_html__( 'Style', 'solene' ),
					'options' => array(
						'solid'  => esc_html__( 'Solid', 'solene' ),
						'dashed' => esc_html__( 'Dashed', 'solene' ),
						'dotted' => esc_html__( 'Dotted', 'solene' )
					)
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'width',
					'title' => esc_html__( 'Width (px or %)', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'thickness',
					'title' => esc_html__( 'Thickness (px)', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_margin',
					'title' => esc_html__( 'Top Margin (px or %)', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'bottom_margin',
					'title' => esc_html__( 'Bottom Margin (px or %)', 'solene' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			//prepare variables
			$params = '';
			
			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}
			
			echo '<div class="widget eltdf-separator-widget">';
			echo do_shortcode( "[eltdf_separator $params]" ); // XSS OK
			echo '</div>';
		}
	}
}