<?php

if ( class_exists( 'SoleneCoreClassWidget' ) ) {
	class SoleneElatedClassStampWidget extends SoleneCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'eltdf_stamp_widget',
				esc_html__( 'Solene Stamp Widget', 'solene' ),
				array( 'description' => esc_html__( 'Add a stamp element to your widget areas', 'solene' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'  => 'textfield',
					'name'  => 'text',
					'title' => esc_html__( 'Stamp Text', 'solene' )
				),
				array(
					'type'  => 'image',
					'name'  => 'image',
					'title' => esc_html__( 'Stamp Image', 'solene' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'link',
					'title' => esc_html__( 'Custom Link', 'solene' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'text_color',
					'title' => esc_html__( 'Text Color', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'text_font_size',
					'title' => esc_html__( 'Text Font Size (px)', 'solene' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'stamp_size',
					'title'       => esc_html__( 'Stamp Size (px)', 'solene' ),
					'description' => esc_html__( 'Default value is 123', 'solene' )
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'disable_stamp',
					'title'       => esc_html__( 'Disable Stamp', 'solene' ),
					'description' => esc_html__( 'Choose on which stage you will hide stamp shortcode', 'solene' ),
					'options'     => array_flip( array(
						esc_html__( 'Never', 'solene' )        => '',
						esc_html__( 'Below 1440px', 'solene' ) => '1440',
						esc_html__( 'Below 1280px', 'solene' ) => '1280',
						esc_html__( 'Below 1024px', 'solene' ) => '1024',
						esc_html__( 'Below 768px', 'solene' )  => '768',
						esc_html__( 'Below 680px', 'solene' )  => '680',
						esc_html__( 'Below 480px', 'solene' )  => '480'
					) )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'appearing_delay',
					'title'       => esc_html__( 'Appearing Delay (ms)', 'solene' ),
					'description' => esc_html__( 'Default value is 0', 'solene' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'enable_repeating_animation',
					'title'   => esc_html__( 'Enable Repeating Animation', 'solene' ),
					'options' => solene_elated_get_yes_no_select_array( false, true )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'absolute_position',
					'title'   => esc_html__( 'Enable Absolute Position', 'solene' ),
					'options' => solene_elated_get_yes_no_select_array( false )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_position',
					'title' => esc_html__( 'Top Position (px or %)', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'left_position',
					'title' => esc_html__( 'Left Position (px or %)', 'solene' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'right_position',
					'title' => esc_html__( 'Right Position (px or %)', 'solene' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			//prepare variables
			$params = '';
			
			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}
			
			echo '<div class="widget eltdf-stamp-widget eltdf-complex-widget">';
			echo do_shortcode( "[eltdf_stamp $params]" ); // XSS OK
			echo '</div>';
		}
	}
}