<?php

if ( ! function_exists( 'solene_elated_map_woocommerce_meta' ) ) {
	function solene_elated_map_woocommerce_meta() {
		
		$woocommerce_meta_box = solene_elated_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'solene' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'solene' ),
				'description' => esc_html__( 'Choose image layout when it appears in Elated Product List - Masonry layout shortcode', 'solene' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'solene' ),
					'small'              => esc_html__( 'Small', 'solene' ),
					'large-width'        => esc_html__( 'Large Width', 'solene' ),
					'large-height'       => esc_html__( 'Large Height', 'solene' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'solene' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'solene' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'solene' ),
				'options'       => solene_elated_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		solene_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'solene' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'solene_elated_action_meta_boxes_map', 'solene_elated_map_woocommerce_meta', 99 );
}