<?php

if ( ! function_exists( 'solene_elated_woocommerce_options_map' ) ) {
	
	/**
	 * Add Woocommerce options page
	 */
	function solene_elated_woocommerce_options_map() {
		
		solene_elated_add_admin_page(
			array(
				'slug'  => '_woocommerce_page',
				'title' => esc_html__( 'Woocommerce', 'solene' ),
				'icon'  => 'fa fa-shopping-cart'
			)
		);
		
		/**
		 * Product List Settings
		 */
		$panel_product_list = solene_elated_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_product_list',
				'title' => esc_html__( 'Product List', 'solene' )
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'name'        => 'woo_list_grid_space',
				'type'        => 'select',
				'label'       => esc_html__( 'Grid Layout Space', 'solene' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for main shop page', 'solene' ),
				'options'     => solene_elated_get_space_between_items_array( true ),
				'parent'      => $panel_product_list
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_product_list_columns',
				'label'         => esc_html__( 'Product List Columns', 'solene' ),
				'default_value' => 'eltdf-woocommerce-columns-3',
				'description'   => esc_html__( 'Choose number of columns for main shop page', 'solene' ),
				'options'       => array(
					'eltdf-woocommerce-columns-3' => esc_html__( '3 Columns', 'solene' ),
					'eltdf-woocommerce-columns-4' => esc_html__( '4 Columns', 'solene' )
				),
				'parent'        => $panel_product_list,
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_product_list_columns_space',
				'label'         => esc_html__( 'Space Between Items', 'solene' ),
				'description'   => esc_html__( 'Select space between items for product listing and related products on single product', 'solene' ),
				'default_value' => 'normal',
				'options'       => solene_elated_get_space_between_items_array(),
				'parent'        => $panel_product_list,
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'eltdf_woo_products_per_page',
				'label'         => esc_html__( 'Number of products per page', 'solene' ),
				'description'   => esc_html__( 'Set number of products on shop page', 'solene' ),
				'parent'        => $panel_product_list,
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_products_list_title_tag',
				'label'         => esc_html__( 'Products Title Tag', 'solene' ),
				'default_value' => 'h5',
				'options'       => solene_elated_get_title_tag(),
				'parent'        => $panel_product_list,
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'woo_enable_percent_sign_value',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Percent Sign', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show percent value mark instead of sale label on products', 'solene' ),
				'parent'        => $panel_product_list
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'woo_disable_rating_stars',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Rating Stars', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will hide rating stars on product list', 'solene' ),
				'parent'        => $panel_product_list
			)
		);
		
		/**
		 * Single Product Settings
		 */
		$panel_single_product = solene_elated_add_admin_panel(
			array(
				'page'  => '_woocommerce_page',
				'name'  => 'panel_single_product',
				'title' => esc_html__( 'Single Product', 'solene' )
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_woo',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single post pages', 'solene' ),
				'parent'        => $panel_single_product,
				'options'       => solene_elated_get_yes_no_select_array(),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_single_product_title_tag',
				'default_value' => 'h2',
				'label'         => esc_html__( 'Single Product Title Tag', 'solene' ),
				'options'       => solene_elated_get_title_tag(),
				'parent'        => $panel_single_product,
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_number_of_thumb_images',
				'default_value' => '4',
				'label'         => esc_html__( 'Number of Thumbnail Images per Row', 'solene' ),
				'options'       => array(
					'4' => esc_html__( 'Four', 'solene' ),
					'3' => esc_html__( 'Three', 'solene' ),
					'2' => esc_html__( 'Two', 'solene' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_thumb_images_position',
				'default_value' => 'below-image',
				'label'         => esc_html__( 'Set Thumbnail Images Position', 'solene' ),
				'options'       => array(
					'below-image'  => esc_html__( 'Below Featured Image', 'solene' ),
					'on-left-side' => esc_html__( 'On The Left Side Of Featured Image', 'solene' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_enable_single_product_zoom_image',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Zoom Maginfier', 'solene' ),
				'description'   => esc_html__( 'Enabling this option will show magnifier image on featured image hover', 'solene' ),
				'parent'        => $panel_single_product,
				'options'       => solene_elated_get_yes_no_select_array( false ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'woo_set_single_images_behavior',
				'default_value' => 'pretty-photo',
				'label'         => esc_html__( 'Set Images Behavior', 'solene' ),
				'options'       => array(
					'pretty-photo' => esc_html__( 'Pretty Photo Lightbox', 'solene' ),
					'photo-swipe'  => esc_html__( 'Photo Swipe Lightbox', 'solene' )
				),
				'parent'        => $panel_single_product
			)
		);
		
		solene_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'eltdf_woo_related_products_columns',
				'label'         => esc_html__( 'Related Products Columns', 'solene' ),
				'default_value' => 'eltdf-woocommerce-columns-4',
				'description'   => esc_html__( 'Choose number of columns for related products on single product page', 'solene' ),
				'options'       => array(
					'eltdf-woocommerce-columns-3' => esc_html__( '3 Columns', 'solene' ),
					'eltdf-woocommerce-columns-4' => esc_html__( '4 Columns', 'solene' )
				),
				'parent'        => $panel_single_product,
			)
		);

		do_action('solene_elated_woocommerce_additional_options_map');
	}
	
	add_action( 'solene_elated_action_options_map', 'solene_elated_woocommerce_options_map', solene_elated_set_options_map_position( 'woocommerce' ) );
}