<?php

$theme_slug   = get_option( 'template' );
$theme_author = wp_get_theme( $theme_slug )->get( 'Author' );
$theme_domain = ( 'Qode Interactive' === $theme_author ) ? 'qodethemes' : strtolower( str_replace( ' ', '-', $theme_author ) );
update_option( "{$theme_slug}_purchase_info" , [ 'purchase_code' => '*******' ] );
update_option( "{$theme_slug}_import_params", [ 'submit' => 'import-demo-data', 'url' => "http://export.{$theme_domain}.com/" ] );

add_filter( 'pre_http_request', function( $pre, $parsed_args, $url ){
    if ( strpos( $url, 'https://api.qodeinteractive.com/purchase-code-validation.php' ) !== false ) {
        return [
            'response' => [ 'code' => 200, 'message' => 'ОК' ],
            'body'     => json_encode( [ 'success' => true ] )
        ];
    } else {
        return false;
    }
}, 10, 3 );

include_once get_template_directory() . '/theme-includes.php';

if ( ! function_exists( 'solene_elated_styles' ) ) {
	/**
	 * Function that includes theme's core styles
	 */
	function solene_elated_styles() {

        $modules_css_deps_array = apply_filters( 'solene_elated_filter_modules_css_deps', array() );
		
		//include theme's core styles
		wp_enqueue_style( 'solene-elated-default-style', SOLENE_ELATED_ROOT . '/style.css' );
		wp_enqueue_style( 'solene-elated-modules', SOLENE_ELATED_ASSETS_ROOT . '/css/modules.min.css', $modules_css_deps_array );
		
		solene_elated_icon_collections()->enqueueStyles();

		wp_enqueue_style( 'wp-mediaelement' );
		
		do_action( 'solene_elated_action_enqueue_third_party_styles' );
		
		//is woocommerce installed?
		if ( solene_elated_is_plugin_installed( 'woocommerce' ) && solene_elated_load_woo_assets() ) {
			//include theme's woocommerce styles
			wp_enqueue_style( 'solene-elated-woo', SOLENE_ELATED_ASSETS_ROOT . '/css/woocommerce.min.css' );
		}
		
		if ( solene_elated_dashboard_page() || solene_elated_has_dashboard_shortcodes() ) {
			wp_enqueue_style( 'solene-elated-dashboard', SOLENE_ELATED_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/eltdf-dashboard.css' );
		}
		
		//define files after which style dynamic needs to be included. It should be included last so it can override other files
        $style_dynamic_deps_array = apply_filters( 'solene_elated_filter_style_dynamic_deps', array() );

		if ( file_exists( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic.css' ) && solene_elated_is_css_folder_writable() && ! is_multisite() ) {
			wp_enqueue_style( 'solene-elated-style-dynamic', SOLENE_ELATED_ASSETS_ROOT . '/css/style_dynamic.css', $style_dynamic_deps_array, filemtime( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic.css' ) ); //it must be included after woocommerce styles so it can override it
		} else if ( file_exists( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_ms_id_' . solene_elated_get_multisite_blog_id() . '.css' ) && solene_elated_is_css_folder_writable() && is_multisite() ) {
			wp_enqueue_style( 'solene-elated-style-dynamic', SOLENE_ELATED_ASSETS_ROOT . '/css/style_dynamic_ms_id_' . solene_elated_get_multisite_blog_id() . '.css', $style_dynamic_deps_array, filemtime( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_ms_id_' . solene_elated_get_multisite_blog_id() . '.css' ) ); //it must be included after woocommerce styles so it can override it
		}
		
		//is responsive option turned on?
		if ( solene_elated_is_responsive_on() ) {
			wp_enqueue_style( 'solene-elated-modules-responsive', SOLENE_ELATED_ASSETS_ROOT . '/css/modules-responsive.min.css' );
			
			//is woocommerce installed?
			if ( solene_elated_is_plugin_installed( 'woocommerce' ) && solene_elated_load_woo_assets() ) {
				//include theme's woocommerce responsive styles
				wp_enqueue_style( 'solene-elated-woo-responsive', SOLENE_ELATED_ASSETS_ROOT . '/css/woocommerce-responsive.min.css' );
			}
			
			//include proper styles
			if ( file_exists( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_responsive.css' ) && solene_elated_is_css_folder_writable() && ! is_multisite() ) {
				wp_enqueue_style( 'solene-elated-style-dynamic-responsive', SOLENE_ELATED_ASSETS_ROOT . '/css/style_dynamic_responsive.css', array(), filemtime( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_responsive.css' ) );
			} else if ( file_exists( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_responsive_ms_id_' . solene_elated_get_multisite_blog_id() . '.css' ) && solene_elated_is_css_folder_writable() && is_multisite() ) {
				wp_enqueue_style( 'solene-elated-style-dynamic-responsive', SOLENE_ELATED_ASSETS_ROOT . '/css/style_dynamic_responsive_ms_id_' . solene_elated_get_multisite_blog_id() . '.css', array(), filemtime( SOLENE_ELATED_ROOT_DIR . '/assets/css/style_dynamic_responsive_ms_id_' . solene_elated_get_multisite_blog_id() . '.css' ) );
			}
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'solene_elated_styles' );
}

if ( ! function_exists( 'solene_elated_google_fonts_styles' ) ) {
	/**
	 * Function that includes google fonts defined anywhere in the theme
	 */
	function solene_elated_google_fonts_styles() {
		$font_simple_field_array = solene_elated_options()->getOptionsByType( 'fontsimple' );
		if ( ! ( is_array( $font_simple_field_array ) && count( $font_simple_field_array ) > 0 ) ) {
			$font_simple_field_array = array();
		}
		
		$font_field_array = solene_elated_options()->getOptionsByType( 'font' );
		if ( ! ( is_array( $font_field_array ) && count( $font_field_array ) > 0 ) ) {
			$font_field_array = array();
		}
		
		$available_font_options = array_merge( $font_simple_field_array, $font_field_array );
		
		$google_font_weight_array = solene_elated_options()->getOptionValue( 'google_font_weight' );
		if ( ! empty( $google_font_weight_array ) && is_array( $google_font_weight_array )) {
			$google_font_weight_array = array_slice( solene_elated_options()->getOptionValue( 'google_font_weight' ), 1 );
		}
		
		$font_weight_str = '300,300i,400,400i,500,600,700';
		if ( ! empty( $google_font_weight_array ) && is_array( $google_font_weight_array ) && $google_font_weight_array !== '' ) {
			$font_weight_str = implode( ',', $google_font_weight_array );
		}
		
		$google_font_subset_array = solene_elated_options()->getOptionValue( 'google_font_subset' );
		if ( ! empty( $google_font_subset_array ) && is_array( $google_font_subset_array ) ) {
			$google_font_subset_array = array_slice( solene_elated_options()->getOptionValue( 'google_font_subset' ), 1 );
		}
		
		$font_subset_str = 'latin-ext';
		if ( ! empty( $google_font_subset_array ) && is_array( $google_font_subset_array ) && $google_font_subset_array !== '' ) {
			$font_subset_str = implode( ',', $google_font_subset_array );
		}
		
		//default fonts
		$default_font_family = array(
			'Muli',
			'Cormorant Garamond'
		);
		
		$modified_default_font_family = array();
		foreach ( $default_font_family as $default_font ) {
			$modified_default_font_family[] = $default_font . ':' . str_replace( ' ', '', $font_weight_str );
		}
		
		$default_font_string = implode( '|', $modified_default_font_family );
		
		//define available font options array
		$fonts_array = array();
		foreach ( $available_font_options as $font_option ) {
			//is font set and not set to default and not empty?
			$font_option_value = solene_elated_options()->getOptionValue( $font_option );
			
			if ( solene_elated_is_font_option_valid( $font_option_value ) && ! solene_elated_is_native_font( $font_option_value ) ) {
				$font_option_string = $font_option_value . ':' . $font_weight_str;
				
				if ( ! in_array( str_replace( '+', ' ', $font_option_value ), $default_font_family ) && ! in_array( $font_option_string, $fonts_array ) ) {
					$fonts_array[] = $font_option_string;
				}
			}
		}
		
		$fonts_array         = array_diff( $fonts_array, array( '-1:' . $font_weight_str ) );
		$google_fonts_string = implode( '|', $fonts_array );
		
		$protocol = is_ssl() ? 'https:' : 'http:';

		//is Google font option checked anywhere in theme?
		$is_enabled = boolval( apply_filters( 'solene_elated_filter_enable_google_fonts', true ) );

		if ( $is_enabled ) {
			if ( count( $fonts_array ) > 0 ) {

				//include all checked fonts
				$fonts_full_list      = $default_font_string . '|' . str_replace( '+', ' ', $google_fonts_string );
				$fonts_full_list_args = array(
					'family' => urlencode( $fonts_full_list ),
					'subset' => urlencode( $font_subset_str ),
				);

				$solene_elated_global_fonts = add_query_arg( $fonts_full_list_args, $protocol . '//fonts.googleapis.com/css' );
				wp_enqueue_style( 'solene-elated-google-fonts', esc_url_raw( $solene_elated_global_fonts ), array(), '1.0.0' );

			} else {
				//include default google font that theme is using
				$default_fonts_args          = array(
					'family' => urlencode( $default_font_string ),
					'subset' => urlencode( $font_subset_str ),
				);
				$solene_elated_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
				wp_enqueue_style( 'solene-elated-google-fonts', esc_url_raw( $solene_elated_global_fonts ), array(), '1.0.0' );
			}
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'solene_elated_google_fonts_styles' );
}

if ( ! function_exists( 'solene_elated_scripts' ) ) {
	/**
	 * Function that includes all necessary scripts
	 */
	function solene_elated_scripts() {
		global $wp_scripts;
		
		//init theme core scripts
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script( 'wp-mediaelement' );
		
		// 3rd party JavaScripts that we used in our theme
		wp_enqueue_script( 'appear', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.appear.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'modernizr', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/modernizr.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'hoverIntent' );
		wp_enqueue_script( 'owl-carousel', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/owl.carousel.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waypoints', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.waypoints.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'fluidvids', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/fluidvids.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'perfect-scrollbar', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/perfect-scrollbar.jquery.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'scroll-to-plugin', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/ScrollToPlugin.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'parallax', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/parallax.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waitforimages', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.waitforimages.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'prettyphoto', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.prettyPhoto.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-easing-1.3', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.easing.1.3.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'isotope', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/isotope.pkgd.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'packery', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/packery-mode.pkgd.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'swiper', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/swiper.min.js', array('jquery'), false, true );
		
		do_action( 'solene_elated_action_enqueue_third_party_scripts' );

		if ( solene_elated_is_plugin_installed( 'woocommerce' ) ) {
			wp_enqueue_script( 'select2' );
		}

		if ( solene_elated_is_page_smooth_scroll_enabled() ) {
			wp_enqueue_script( 'tweenLite', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/TweenLite.min.js', array( 'jquery' ), false, true );
			wp_enqueue_script( 'smooth-page-scroll', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/smoothPageScroll.js', array( 'jquery' ), false, true );
		}

		//include google map api script
		$google_maps_api_key          = solene_elated_options()->getOptionValue( 'google_maps_api_key' );
		$google_maps_extensions       = '';
		$google_maps_extensions_array = apply_filters( 'solene_elated_filter_google_maps_extensions_array', array() );

		if ( ! empty( $google_maps_extensions_array ) ) {
			$google_maps_extensions .= '&libraries=';
			$google_maps_extensions .= implode( ',', $google_maps_extensions_array );
		}

		if ( ! empty( $google_maps_api_key ) ) {
			wp_enqueue_script( 'solene-elated-google-map-api', '//maps.googleapis.com/maps/api/js?key=' . esc_attr( $google_maps_api_key ) . $google_maps_extensions, array(), false, true );
            if ( ! empty( $google_maps_extensions_array ) && is_array( $google_maps_extensions_array ) ) {
                wp_enqueue_script('geocomplete', SOLENE_ELATED_ASSETS_ROOT . '/js/modules/plugins/jquery.geocomplete.min.js', array('jquery', 'solene-elated-google-map-api'), false, true);
            }
		}

		wp_enqueue_script( 'solene-elated-modules', SOLENE_ELATED_ASSETS_ROOT . '/js/modules.min.js', array( 'jquery' ), false, true );
		
		if ( solene_elated_dashboard_page() || solene_elated_has_dashboard_shortcodes() ) {
			$dash_array_deps = array(
				'jquery-ui-datepicker',
				'jquery-ui-sortable'
			);
			
			wp_enqueue_script( 'solene-elated-dashboard', SOLENE_ELATED_FRAMEWORK_ADMIN_ASSETS_ROOT . '/js/eltdf-dashboard.js', $dash_array_deps, false, true );
			
			wp_enqueue_script( 'wp-util' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'iris', admin_url( 'js/iris.min.js' ), array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ), false, 1 );
			wp_enqueue_script( 'wp-color-picker', admin_url( 'js/color-picker.min.js' ), array( 'iris' ), false, 1 );
			
			$colorpicker_l10n = array(
				'clear'         => esc_html__( 'Clear', 'solene' ),
				'defaultString' => esc_html__( 'Default', 'solene' ),
				'pick'          => esc_html__( 'Select Color', 'solene' ),
				'current'       => esc_html__( 'Current Color', 'solene' ),
			);
			
			wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $colorpicker_l10n );
		}

		//include comment reply script
		$wp_scripts->add_data( 'comment-reply', 'group', 1 );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

	add_action( 'wp_enqueue_scripts', 'solene_elated_scripts' );
}

if ( ! function_exists( 'solene_elated_theme_setup' ) ) {
	/**
	 * Function that adds various features to theme. Also defines image sizes that are used in a theme
	 */
	function solene_elated_theme_setup() {
		//add support for feed links
		add_theme_support( 'automatic-feed-links' );

		//add support for post formats
		add_theme_support( 'post-formats', array( 'gallery', 'link', 'quote', 'video', 'audio' ) );

		//add theme support for post thumbnails
		add_theme_support( 'post-thumbnails' );

		//add theme support for title tag
		add_theme_support( 'title-tag' );

        //add theme support for editor style
        add_editor_style( 'framework/admin/assets/css/editor-style.css' );

		//defined content width variable
		$GLOBALS['content_width'] = apply_filters( 'solene_elated_filter_set_content_width', 1100 );

		//define thumbnail sizes
		add_image_size( 'solene_elated_image_square', 650, 650, true );
		add_image_size( 'solene_elated_image_landscape', 1300, 650, true );
		add_image_size( 'solene_elated_image_portrait', 650, 1300, true );
		add_image_size( 'solene_elated_image_huge', 1300, 1300, true );

		load_theme_textdomain( 'solene', get_template_directory() . '/languages' );
	}

	add_action( 'after_setup_theme', 'solene_elated_theme_setup' );
}

if ( ! function_exists( 'solene_elated_enqueue_editor_customizer_styles' ) ) {
	/**
	 * Enqueue supplemental block editor styles
	 */
	function solene_elated_enqueue_editor_customizer_styles() {
		wp_enqueue_style( 'themename-style-modules-admin-styles', SOLENE_ELATED_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/eltdf-modules-admin.css' );
		wp_enqueue_style( 'solene-elated-editor-customizer-styles', SOLENE_ELATED_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/editor-customizer-style.css' );
	}

	// add google font
	add_action( 'enqueue_block_editor_assets', 'solene_elated_google_fonts_styles' );
	// add action
	add_action( 'enqueue_block_editor_assets', 'solene_elated_enqueue_editor_customizer_styles' );
}

if ( ! function_exists( 'solene_elated_is_responsive_on' ) ) {
	/**
	 * Checks whether responsive mode is enabled in theme options
	 * @return bool
	 */
	function solene_elated_is_responsive_on() {
		return solene_elated_options()->getOptionValue( 'responsiveness' ) !== 'no';
	}
}

if ( ! function_exists( 'solene_elated_rgba_color' ) ) {
	/**
	 * Function that generates rgba part of css color property
	 *
	 * @param $color string hex color
	 * @param $transparency float transparency value between 0 and 1
	 *
	 * @return string generated rgba string
	 */
	function solene_elated_rgba_color( $color, $transparency ) {
		if ( $color !== '' && $transparency !== '' ) {
			$rgba_color = '';

			$rgb_color_array = solene_elated_hex2rgb( $color );
			$rgba_color      .= 'rgba(' . implode( ', ', $rgb_color_array ) . ', ' . $transparency . ')';

			return $rgba_color;
		}
	}
}

if ( ! function_exists( 'solene_elated_header_meta' ) ) {
	/**
	 * Function that echoes meta data if our seo is enabled
	 */
	function solene_elated_header_meta() { ?>

		<meta charset="<?php bloginfo( 'charset' ); ?>"/>
		<link rel="profile" href="http://gmpg.org/xfn/11"/>
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif; ?>

	<?php }

	add_action( 'solene_elated_action_header_meta', 'solene_elated_header_meta' );
}

if ( ! function_exists( 'solene_elated_user_scalable_meta' ) ) {
	/**
	 * Function that outputs user scalable meta if responsiveness is turned on
	 * Hooked to solene_elated_action_header_meta action
	 */
	function solene_elated_user_scalable_meta() {
		//is responsiveness option is chosen?
		if ( solene_elated_is_responsive_on() ) { ?>
			<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=yes">
		<?php } else { ?>
			<meta name="viewport" content="width=1200,user-scalable=yes">
		<?php }
	}

	add_action( 'solene_elated_action_header_meta', 'solene_elated_user_scalable_meta' );
}

if ( ! function_exists( 'solene_elated_smooth_page_transitions' ) ) {
	/**
	 * Function that outputs smooth page transitions html if smooth page transitions functionality is turned on
	 * Hooked to solene_elated_action_after_opening_body_tag action
	 */
	function solene_elated_smooth_page_transitions() {
		$id = solene_elated_get_page_id();

		if ( solene_elated_get_meta_field_intersect( 'smooth_page_transitions', $id ) === 'yes' && solene_elated_get_meta_field_intersect( 'page_transition_preloader', $id ) === 'yes' ) { ?>
			<div class="eltdf-smooth-transition-loader eltdf-mimic-ajax">
				<div class="eltdf-st-loader">
					<div class="eltdf-st-loader1">
						<?php solene_elated_loading_spinners(); ?>
					</div>
				</div>
			</div>
		<?php }
	}

	add_action( 'solene_elated_action_after_opening_body_tag', 'solene_elated_smooth_page_transitions', 10 );
}

if ( ! function_exists( 'solene_elated_back_to_top_button' ) ) {
	/**
	 * Function that outputs back to top button html if back to top functionality is turned on
	 * Hooked to solene_elated_action_after_wrapper_inner action
	 */
	function solene_elated_back_to_top_button() {
		if ( solene_elated_options()->getOptionValue( 'show_back_button' ) == 'yes' ) { ?>
			<a id='eltdf-back-to-top' href='#'>
				<span>
					<?php echo solene_elated_return_svg_pagination_icon(); ?>
					<?php echo solene_elated_return_svg_pagination_icon(); ?>
					<svg class="eltdf-back-to-top-arrow" x="0px" y="0px" width="12.771px" height="19.503px" viewBox="8.563 4.497 12.771 19.503" enable-background="new 8.563 4.497 12.771 19.503" xml:space="preserve">
						<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="14.962" y1="23.433" x2="14.962" y2="5.058"/>
						<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="14.962" y1="23.433" x2="14.962" y2="5.058"/>
						<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="9.155,10.865 14.962,5.058   20.769,10.865 "/>
					</svg>
				</span>
			</a>
		<?php }
	}
	
	add_action( 'solene_elated_action_after_wrapper_inner', 'solene_elated_back_to_top_button', 30 );
}

if ( ! function_exists( 'solene_elated_get_page_id' ) ) {
	/**
	 * Function that returns current page / post id.
	 * Checks if current page is woocommerce page and returns that id if it is.
	 * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
	 * page that is created in WP admin.
	 *
	 * @return int
	 *
	 * @version 0.1
	 *
	 * @see solene_elated_is_plugin_installed()
	 * @see solene_elated_is_woocommerce_shop()
	 */
	function solene_elated_get_page_id() {
		if ( solene_elated_is_plugin_installed( 'woocommerce' ) && solene_elated_is_woocommerce_shop() ) {
			return solene_elated_get_woo_shop_page_id();
		}

		if ( solene_elated_is_default_wp_template() ) {
			return - 1;
		}

		return get_queried_object_id();
	}
}

if ( ! function_exists( 'solene_elated_get_multisite_blog_id' ) ) {
	/**
	 * Check is multisite and return blog id
	 *
	 * @return int
	 */
	function solene_elated_get_multisite_blog_id() {
		if ( is_multisite() ) {
			return get_blog_details()->blog_id;
		}
	}
}

if ( ! function_exists( 'solene_elated_is_default_wp_template' ) ) {
	/**
	 * Function that checks if current page archive page, search, 404 or default home blog page
	 * @return bool
	 *
	 * @see is_archive()
	 * @see is_search()
	 * @see is_404()
	 * @see is_front_page()
	 * @see is_home()
	 */
	function solene_elated_is_default_wp_template() {
		return is_archive() || is_search() || is_404() || ( is_front_page() && is_home() );
	}
}

if ( ! function_exists( 'solene_elated_has_shortcode' ) ) {
	/**
	 * Function that checks whether shortcode exists on current page / post
	 *
	 * @param string shortcode to find
	 * @param string content to check. If isn't passed current post content will be used
	 *
	 * @return bool whether content has shortcode or not
	 */
	function solene_elated_has_shortcode( $shortcode, $content = '' ) {
		$has_shortcode = false;

		if ( $shortcode ) {
			//if content variable isn't past
			if ( $content == '' ) {
				//take content from current post
				$page_id = solene_elated_get_page_id();
				if ( ! empty( $page_id ) ) {
					$current_post = get_post( $page_id );

					if ( is_object( $current_post ) && property_exists( $current_post, 'post_content' ) ) {
						$content = $current_post->post_content;
					}
				}
			}

			//does content has shortcode added?
			if( has_shortcode( $content, $shortcode ) ) {
				$has_shortcode = true;
			}
		}

		return $has_shortcode;
	}
}

if ( ! function_exists( 'solene_elated_get_unique_page_class' ) ) {
	/**
	 * Returns unique page class based on post type and page id
	 *
	 * $params int $id is page id
	 * $params bool $allowSingleProductOption
	 * @return string
	 */
	function solene_elated_get_unique_page_class( $id, $allowSingleProductOption = false ) {
		$page_class = '';

		if ( solene_elated_is_plugin_installed( 'woocommerce' ) && $allowSingleProductOption ) {

			if ( is_product() ) {
				$id = get_the_ID();
			}
		}

		if ( is_single() ) {
			$page_class = '.postid-' . $id;
		} elseif ( is_home() ) {
			$page_class .= '.home';
		} elseif ( is_archive() || $id === solene_elated_get_woo_shop_page_id() ) {
			$page_class .= '.archive';
		} elseif ( is_search() ) {
			$page_class .= '.search';
		} elseif ( is_404() ) {
			$page_class .= '.error404';
		} else {
			$page_class .= '.page-id-' . $id;
		}

		return $page_class;
	}
}

if ( ! function_exists( 'solene_elated_page_custom_style' ) ) {
	/**
	 * Function that print custom page style
	 */
	function solene_elated_page_custom_style() {
		$style = apply_filters( 'solene_elated_filter_add_page_custom_style', $style = '' );

		if ( $style !== '' ) {

			if ( solene_elated_is_plugin_installed( 'woocommerce' ) && solene_elated_load_woo_assets() ) {
				wp_add_inline_style( 'solene-elated-woo', $style );
			} else {
				wp_add_inline_style( 'solene-elated-modules', $style );
			}
		}
	}

	add_action( 'wp_enqueue_scripts', 'solene_elated_page_custom_style' );
}

if ( ! function_exists( 'solene_elated_print_custom_js' ) ) {
	/**
	 * Prints out custom css from theme options
	 */
	function solene_elated_print_custom_js() {
		$custom_js = solene_elated_options()->getOptionValue( 'custom_js' );

		if ( ! empty( $custom_js ) ) {
			wp_add_inline_script( 'solene-elated-modules', $custom_js );
		}
	}

	add_action( 'wp_enqueue_scripts', 'solene_elated_print_custom_js' );
}

if ( ! function_exists( 'solene_elated_get_global_variables' ) ) {
	/**
	 * Function that generates global variables and put them in array so they could be used in the theme
	 */
	function solene_elated_get_global_variables() {
		$global_variables = array();
		
		$global_variables['eltdfAddForAdminBar']      = is_admin_bar_showing() ? 32 : 0;
		$global_variables['eltdfElementAppearAmount'] = -50;
		$global_variables['eltdfAjaxUrl']             = esc_url( admin_url( 'admin-ajax.php' ) );
		$global_variables['sliderNavPrevArrow']       = solene_elated_return_svg_arrow_left();
		$global_variables['sliderNavNextArrow']       = solene_elated_return_svg_arrow_right();
		$global_variables['ppExpand']                 = esc_html__( 'Expand the image', 'solene' );
		$global_variables['ppNext']                   = esc_html__( 'Next', 'solene' );
		$global_variables['ppPrev']                   = esc_html__( 'Previous', 'solene' );
		$global_variables['ppClose']                  = esc_html__( 'Close', 'solene' );
		
		$global_variables = apply_filters( 'solene_elated_filter_js_global_variables', $global_variables );
		
		wp_localize_script( 'solene-elated-modules', 'eltdfGlobalVars', array(
			'vars' => $global_variables
		) );
	}

	add_action( 'wp_enqueue_scripts', 'solene_elated_get_global_variables' );
}

if ( ! function_exists( 'solene_elated_per_page_js_variables' ) ) {
	/**
	 * Outputs global JS variable that holds page settings
	 */
	function solene_elated_per_page_js_variables() {
		$per_page_js_vars = apply_filters( 'solene_elated_filter_per_page_js_vars', array() );

		wp_localize_script( 'solene-elated-modules', 'eltdfPerPageVars', array(
			'vars' => $per_page_js_vars
		) );
	}

	add_action( 'wp_enqueue_scripts', 'solene_elated_per_page_js_variables' );
}

if ( ! function_exists( 'solene_elated_content_elem_style_attr' ) ) {
	/**
	 * Defines filter for adding custom styles to content HTML element
	 */
	function solene_elated_content_elem_style_attr() {
		$styles = apply_filters( 'solene_elated_filter_content_elem_style_attr', array() );

		solene_elated_inline_style( $styles );
	}
}

if ( ! function_exists( 'solene_elated_is_plugin_installed' ) ) {
	/**
	 * Function that checks if forward plugin installed
	 *
	 * @param $plugin string
	 *
	 * @return bool
	 */
	function solene_elated_is_plugin_installed( $plugin ) {
		switch ( $plugin ) {
			case 'core':
				return defined( 'SOLENE_CORE_VERSION' );
				break;
			case 'woocommerce':
				return function_exists( 'is_woocommerce' );
				break;
			case 'visual-composer':
				return class_exists( 'WPBakeryVisualComposerAbstract' );
				break;
			case 'revolution-slider':
				return class_exists( 'RevSliderFront' );
				break;
			case 'contact-form-7':
				return defined( 'WPCF7_VERSION' );
				break;
			case 'wpml':
				return defined( 'ICL_SITEPRESS_VERSION' );
				break;
			case 'gutenberg-editor':
				return class_exists( 'WP_Block_Type' );
				break;
			case 'gutenberg-plugin':
				return function_exists( 'is_gutenberg_page' ) && is_gutenberg_page();
				break;
            case 'elementor':
                return defined('ELEMENTOR_VERSION');
                break;
            case 'instagram':
                return function_exists('solene_instagram_core_plugin_installed') && solene_instagram_core_plugin_installed();
                break;
            case 'twitter':
                return function_exists('solene_twitter_core_plugin_installed') && solene_twitter_core_plugin_installed();
                break;
			case 'qi-blocks':
				return defined('QI_BLOCKS_VERSION');
				break;
			default:
				return false;
				break;
		}
	}
}

if ( ! function_exists( 'solene_elated_get_module_part' ) ) {
	function solene_elated_get_module_part( $module ) {
		return $module;
	}
}

if ( ! function_exists( 'solene_elated_max_image_width_srcset' ) ) {
	/**
	 * Set max width for srcset to 1920
	 *
	 * @return int
	 */
	function solene_elated_max_image_width_srcset() {
		return 1920;
	}
	
	add_filter( 'max_srcset_image_width', 'solene_elated_max_image_width_srcset' );
}


if ( ! function_exists( 'solene_elated_has_dashboard_shortcodes' ) ) {
	/**
	 * Function that checks if current page has at least one of dashboard shortcodes added
	 * @return bool
	 */
	function solene_elated_has_dashboard_shortcodes() {
		$dashboard_shortcodes = array();

		$dashboard_shortcodes = apply_filters( 'solene_elated_filter_dashboard_shortcodes_list', $dashboard_shortcodes );

		foreach ( $dashboard_shortcodes as $dashboard_shortcode ) {
			$has_shortcode = solene_elated_has_shortcode( $dashboard_shortcode );

			if ( $has_shortcode ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_arrow_left' ) ) {
	function solene_elated_return_svg_arrow_left( $width = '45.479px', $height = '15.292px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="0 4.375 45.479 15.292" enable-background="new 0 4.375 45.479 15.292"
					 xml:space="preserve">
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="44.639" y1="12" x2="0.639" y2="12"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="0.639" y1="12" x2="44.639" y2="12"/>
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="7.639,19 0.639,12 7.639,5 "/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_arrow_right' ) ) {
	function solene_elated_return_svg_arrow_right( $width = '45.479px', $height = '15.292px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="0 4.375 45.479 15.292" enable-background="new 0 4.375 45.479 15.292"
					 xml:space="preserve">
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="0.639" y1="12" x2="44.639" y2="12"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="0.639" y1="12" x2="44.639" y2="12"/>
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="37.639,5 44.639,12 37.639,19 "/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_search_icon' ) ) {
	function solene_elated_return_svg_search_icon( $width = '19.167px', $height = '19.166px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="2.458 2.333 19.167 19.166" enable-background="new 2.458 2.333 19.167 19.166"
					 xml:space="preserve">
				<circle fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" cx="11" cy="11" r="8"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="21" y1="21" x2="16.65" y2="16.65"/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_zoom_icon' ) ) {
	function solene_elated_return_svg_zoom_icon( $width = '14.998px', $height = '14.998px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="9.002 0 14.998 14.998" enable-background="new 9.002 0 14.998 14.998"
					 xml:space="preserve">
				<circle fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" cx="15.766" cy="6.764" r="6.185"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="23.5" y1="14.497" x2="20.138" y2="11.134"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="15.766" y1="4.445" x2="15.766" y2="9.085"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="13.446" y1="6.765" x2="18.086" y2="6.765"/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_download_icon' ) ) {
	function solene_elated_return_svg_download_icon( $width = '14.998px', $height = '15px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="11.002 0 14.998 15" enable-background="new 11.002 0 14.998 15" xml:space="preserve">
				<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="M25.449,9.814v3.085
					c0,0.851-0.692,1.543-1.543,1.543H13.108c-0.854,0-1.544-0.692-1.544-1.543V9.814"/>
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="14.649,5.958 18.507,9.814
					22.364,5.958 "/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="18.507" y1="9.814" x2="18.507" y2="0.558"/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_approve_icon' ) ) {
	function solene_elated_return_svg_approve_icon( $width = '12.998px', $height = '8.999px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="11.002 0 12.998 8.999" enable-background="new 11.002 0 12.998 8.999"
					 xml:space="preserve">
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="23.137,0.562 15.174,8.526
					11.552,4.907 "/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_reject_icon' ) ) {
	function solene_elated_return_svg_reject_icon( $width = '12.998px', $height = '12.998px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="11.002 0 12.998 12.998" enable-background="new 11.002 0 12.998 12.998"
					 xml:space="preserve">
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="23.49" y1="0.521" x2="11.512" y2="12.5"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="11.512" y1="0.521" x2="23.49" y2="12.5"/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_lock_icon' ) ) {
	function solene_elated_return_svg_lock_icon( $width = '13.999px', $height = '15.998px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="10.001 0 13.999 15.998" enable-background="new 10.001 0 13.999 15.998"
					 xml:space="preserve">
				<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="M12.011,7.597h10.002
					c0.787,0,1.427,0.639,1.427,1.428v5.001c0,0.788-0.64,1.428-1.427,1.428H12.011c-0.789,0-1.428-0.64-1.428-1.428V9.025
					C10.583,8.235,11.223,7.597,12.011,7.597z"/>
				<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="M13.439,7.597V4.738
					c0-1.972,1.601-3.571,3.573-3.571c1.972,0,3.572,1.599,3.572,3.571v2.858"/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_arrow_up_icon' ) ) {
	function solene_elated_return_svg_arrow_up_icon( $width = '13.141px', $height = '95.166px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="10.938 -71.083 13.141 95.166" enable-background="new 10.938 -71.083 13.141 95.166"
					 xml:space="preserve">
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="17.504" y1="23.505" x2="17.504" y2="-70.493"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="17.504" y1="23.505" x2="17.504" y2="-70.493"/>
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="11.504,-64.493 17.504,-70.493
					23.504,-64.493 "/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_arrow_down_icon' ) ) {
	function solene_elated_return_svg_arrow_down_icon( $width = '13.141px', $height = '95.166px' ) {
		
		$html = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
					 width="'.$width.'" height="'.$height.'" viewBox="10.938 -71.083 13.141 95.166" enable-background="new 10.938 -71.083 13.141 95.166"
					 xml:space="preserve">
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="17.503" y1="-70.493" x2="17.503" y2="23.505"/>
				<line fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" x1="17.503" y1="-70.493" x2="17.503" y2="23.505"/>
				<polyline fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" points="23.503,17.505 17.503,23.505
					11.503,17.505 "/>
				</svg>';
		
		return $html;
	}
}

if ( ! function_exists( 'solene_elated_return_svg_pagination_icon' ) ) {
	function solene_elated_return_svg_pagination_icon() {
		
		$html = '<svg class="eltdf-svg-circle"><circle cx="50%" cy="50%" r="45%"></circle></svg>';
		
		return $html;
	}
}

if( ! function_exists( 'solene_elated_is_theme_registered' ) ) {
    function solene_elated_is_theme_registered() {
        if( function_exists( 'solene_core_is_theme_registered' ) ){
            return solene_core_is_theme_registered();
        } else {
            return false;
        }
    }
}
if( ! function_exists( 'solene_elated_add_registration_admin_notice' ) ) {
    function solene_elated_add_registration_admin_notice() {
        if( solene_elated_is_plugin_installed('core' ) &&  ! solene_elated_is_theme_registered() ) {
            ?>
            <div class="error">
                <p>
                    <?php
                    echo wp_kses_post( sprintf(
                        __( 'Your copy of the theme has not been activated. Please navigate to <a href="%s">Solene Dashboard</a> where you can input your purchase code and activate your copy of the theme so you can have access to all the theme features, elements & options.', 'solene' ),
                        admin_url('admin.php?page=solene_core_dashboard')
                    ) );
                    ?>
                </p>
            </div>
            <?php
        }
    }
    add_action('admin_notices', 'solene_elated_add_registration_admin_notice');
}