<?php

if ( ! function_exists( 'solene_elated_register_required_plugins' ) ) {
	/**
	 * Registers theme required and optional plugins. Hooks to tgmpa_register hook
	 */
	function solene_elated_register_required_plugins() {
		$plugins = array(
			array(
				'name'               => esc_html__( 'WPBakery Page Builder', 'solene' ),
				'slug'               => 'js_composer',
				'source'             => get_template_directory() . '/includes/plugins/js_composer.zip',
				'version'            => '6.13.0',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Elementor', 'solene' ),
				'slug'               => 'elementor',
				'required'           => false
			),
			array(
				'name'               => esc_html__( 'Qi Addons for Elementor', 'solene' ),
				'slug'               => 'qi-addons-for-elementor',
				'required'           => false
			),
			array(
				'name'               => esc_html__( 'Qi Blocks', 'solene' ),
				'slug'               => 'qi-blocks',
				'required'           => true,
			),
			array(
				'name'               => esc_html__( 'Revolution Slider', 'solene' ),
				'slug'               => 'revslider',
				'source'             => get_template_directory() . '/includes/plugins/revslider.zip',
				'version'            => '6.6.14',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Solene Core', 'solene' ),
				'slug'               => 'solene-core',
				'source'             => get_template_directory() . '/includes/plugins/solene-core.zip',
				'version'            => '2.3.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Solene Instagram Feed', 'solene' ),
				'slug'               => 'solene-instagram-feed',
				'source'             => get_template_directory() . '/includes/plugins/solene-instagram-feed.zip',
				'version'            => '2.1.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Solene Twitter Feed', 'solene' ),
				'slug'               => 'solene-twitter-feed',
				'source'             => get_template_directory() . '/includes/plugins/solene-twitter-feed.zip',
				'version'            => '1.1.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'     => esc_html__( 'WooCommerce plugin', 'solene' ),
				'slug'     => 'woocommerce',
				'required' => false
			),
			array(
				'name'     => esc_html__( 'Contact Form 7', 'solene' ),
				'slug'     => 'contact-form-7',
				'required' => false
			),
			array(
				'name'     => esc_html__( 'Envato Market', 'solene' ),
				'slug'     => 'envato-market',
				'source'   => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' => false
			)
		);
		
		$config = array(
			'domain'       => 'solene',
			'default_path' => '',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'menu'         => 'install-required-plugins',
			'has_notices'  => true,
			'is_automatic' => false,
			'message'      => '',
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'solene' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'solene' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'solene' ),
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'solene' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'solene' ),
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'solene' ),
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'solene' ),
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'solene' ),
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'solene' ),
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'solene' ),
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'solene' ),
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'solene' ),
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'solene' ),
				'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'solene' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'solene' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'solene' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'solene' ),
				'nag_type'                        => 'updated'
			)
		);
		
		tgmpa( $plugins, $config );
	}
	
	add_action( 'tgmpa_register', 'solene_elated_register_required_plugins' );
}
