<?php
/*
	Plugin Name: JNews - Migration Soledad
	Plugin URI: http://jegtheme.com/
	Description: Content migration plugin from Soledad Theme into JNews Theme
	Version: 11.0.0
	Author: Jegtheme
	Author URI: http://jegtheme.com
	License: GPL2
*/

defined( 'JNEWS_MIGRATION_SOLEDAD' ) || define( 'JNEWS_MIGRATION_SOLEDAD', 'jnews-migration-soledad' );
defined( 'JNEWS_MIGRATION_SOLEDAD_VERSION' ) || define( 'JNEWS_MIGRATION_SOLEDAD_VERSION', '11.0.0' );
defined( 'JNEWS_MIGRATION_SOLEDAD_URL' ) || define( 'JNEWS_MIGRATION_SOLEDAD_URL', plugins_url( 'jnews-migration-soledad' ) );
defined( 'JNEWS_MIGRATION_SOLEDAD_FILE' ) || define( 'JNEWS_MIGRATION_SOLEDAD_FILE', __FILE__ );
defined( 'JNEWS_MIGRATION_SOLEDAD_DIR' ) || define( 'JNEWS_MIGRATION_SOLEDAD_DIR', plugin_dir_path( __FILE__ ) );
defined( 'JNEWS_MIGRATION_SOLEDAD_LANG_DIR' ) || define( 'JNEWS_MIGRATION_SOLEDAD_LANG_DIR', JNEWS_MIGRATION_SOLEDAD_DIR . 'languages' );

/**
 * Get jnews option
 *
 * @param $setting
 * @param $default
 * @return mixed
 */
if ( ! function_exists( 'jnews_get_option' ) ) {
	function jnews_get_option( $setting, $default = null ) {
		$options = get_option( 'jnews_option', array() );
		$value   = $default;
		if ( isset( $options[ $setting ] ) ) {
			$value = $options[ $setting ];
		}
		return $value;
	}
}

/**
 * Load Plugin Dashboard
 */
add_action( 'after_setup_theme', 'jnews_migration_soledad_dashboard' );

if ( ! function_exists( 'jnews_migration_soledad_dashboard' ) ) {
	function jnews_migration_soledad_dashboard() {
		if ( is_admin() ) {
			require_once 'class.jnews-migration-soledad-dashboard.php';
			JNews_Migration_Soledad_Dashboard::getInstance();
		}
	}
}

/**
 * Load Migration Class
 */
add_action( 'after_setup_theme', 'jnews_migration_soledad' );

if ( ! function_exists( 'jnews_migration_soledad' ) ) {
	function jnews_migration_soledad() {
		require_once 'class.jnews-migration-soledad.php';
		JNews_Migration_Soledad::getInstance();
	}
}

/**
 * Load Api Class
 */
add_action( 'after_setup_theme', 'jnews_migration_soledad_api' );

if ( ! function_exists( 'jnews_migration_soledad_api' ) ) {
	function jnews_migration_soledad_api() {
		if ( class_exists( 'JNews\Util\RestAPI' ) ) {
			require_once 'class.jnews-migration-soledad-api.php';
			JNews_Migration_Soledad_Api::getInstance();
		}
	}
}

/**
 * Load Shortcode Class
 */
add_action( 'plugins_loaded', 'JNews_Migration_Soledad_shortcode' );

if ( ! function_exists( 'JNews_Migration_Soledad_shortcode' ) ) {
	function JNews_Migration_Soledad_shortcode() {
		require_once 'class.jnews-migration-soledad-shortcode.php';
		JNews_Migration_Soledad_Shortcode::getInstance();
	}
}

/**
 * Load Text Domain
 */
function JNews_Migration_Soledad_load_textdomain() {
	load_plugin_textdomain( JNEWS_MIGRATION_SOLEDAD, false, JNEWS_MIGRATION_SOLEDAD_LANG_DIR );
}

JNews_Migration_Soledad_load_textdomain();
