<?php

/**
 * JNews Paywall - Frontend Account Subscription Status Template
 */
$subscribe_status  = get_user_option( 'jpw_subscribe_status', get_current_user_id() );
$subscription_type = get_user_option( 'jpw_subs_type', get_current_user_id() );
$subscription_id   = get_user_option( 'jpw_' . $subscription_type . '_subs_id', get_current_user_id() );
$date_format       = get_option( 'date_format' );
$expired           = get_user_option( 'jpw_expired_date', get_current_user_id() );
$expired_timestamp = strtotime( $expired ); // see a5MJp1h5
$current_date      = new DateTime();

if ( $expired_timestamp !== false ) {
	$formatted_date = $expired ? date_i18n( $date_format, strtotime( $expired ) ) : Date( $date_format );
	$expired_date   = new DateTime( '@' . $expired_timestamp ); // Create DateTime from Unix timestamp
	if ( $current_date <= $expired_date ) {
		$remaining = $current_date->diff( $expired_date )->format( '%a ' . esc_html__( 'days', 'jnews-paywall' ) . ' %h ' . esc_html__( 'hours', 'jnews-paywall' ) );
	} else {
		update_user_option( get_current_user_id(), 'jpw_subscribe_status', false );
		$subscribe_status = false;
	}
} else {
	// update jpw status if expried date is empty
	update_user_option( get_current_user_id(), 'jpw_subscribe_status', false );
	$subscribe_status = false;
}

if ( function_exists( 'wcs_get_subscription' ) ) {
	$wcs_order_id = get_user_option( 'jpw_subscribe_id', get_current_user_id() );
	if ( $wcs_order_id ) {
		$subscription_id   = $wcs_order_id;
		$wcs_order         = wcs_get_subscription( $wcs_order_id );
		$subscription_type = $wcs_order->get_payment_method();
	}
}

if ( $subscribe_status && 'ACTIVE' === $subscribe_status ) {
	$mystatus = '<div class="jpw_leftbox">
						<span><strong>' . esc_html__( 'Subscription ID', 'jnews-paywall' ) . ' : </strong>' . $subscription_id . '</span>
                        <span><strong>' . esc_html__( 'Subscription Status', 'jnews-paywall' ) . ' : </strong>' . esc_html__( 'ACTIVE', 'jnews-paywall' ) . '</span>
                        <span><strong>' . esc_html__( 'Remaining Time', 'jnews-paywall' ) . ' : </strong>' . $remaining . '</span>
                        <span><strong>' . esc_html__( 'Next Payment Due', 'jnews-paywall' ) . ' : </strong>' . $formatted_date . '</span>
                        <span><strong>' . esc_html__( 'Payment Type', 'jnews-paywall' ) . ' : </strong>' . ucwords( $subscription_type ) . '</span>
                    </div>
                    <div class="jpw_rightbox">
                        <a class="subscription" href>' . esc_html__( 'Cancel Subscription', 'jnews-paywall' ) . '</a>
                    </div>';
} else {
	$mystatus = '<span>' . esc_html__( 'You are not subscribed', 'jnews-paywall' ) . '</span><div class="btn_wrapper"><a class="button" href="' . ( get_theme_mod( 'jpw_subscribe_url', 'none' ) === 'none' ? '#' : get_permalink( get_theme_mod( 'jpw_subscribe_url', 'none' ) ) ) . '">' . esc_html__( 'Subscribe Now', 'jnews-paywall' ) . '</a></div>';
}

$output = '<div class="jpw_manage_status">
                <div class="jpw_boxed">
                    ' . $mystatus . '
                </div>
            </div>';

echo $output;
