<?php
/**
 * @author Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'JNews_Migration_Newspaper_Api' ) && class_exists( 'JNews\Util\RestAPI' ) ) {
	class JNews_Migration_Newspaper_Api extends JNews\Util\RestAPI {

		/**
		 * @var JNews_Migration_Newspaper_Api
		 */
		private static $instance;

		/**
		 * @return JNews_Migration_Newspaper_Api
		 */
		public static function getInstance() {
			if ( null === static::$instance ) {
				static::$instance = new static();
			}
			return static::$instance;
		}

		/**
		 * Class construction
		 */
		private function __construct() {
			add_action( 'rest_api_init', array( $this, 'register_routes' ) );
		}

		/**
		 * Register API
		 *
		 * @return void
		 */
		public function register_routes() {
			// Migrate Newspaper
			register_rest_route(
				self::ENDPOINT,
				'migrate_newspaper',
				array(
					'methods'             => 'POST',
					'callback'            => array( $this, 'manage_migration' ),
					'permission_callback' => array( $this, 'permission_manage_options' ),
				)
			);
		}

		/**
		 * Manage Migration
		 *
		 * @param WP_REST_Request $request Core class used to implement a REST request object.
		 *
		 * @return array
		 */
		public function manage_migration( $request ) {
			$nonce = sanitize_key( $request->get_param( 'nonce' ) );
			if ( ! wp_verify_nonce( $nonce, 'wp_rest', false ) ) {
				return $this->response_error( esc_html__( 'You are not allowed to perform this action.', 'jnews' ) );
			}
			$migration = JNews_Migration_Newspaper::getInstance();
			return $this->response_success( $migration->content_migration( false, true ) );
		}
	}
}
