<?php

/**
 * @author Jegtheme
 */

namespace JNews\Tiktok\Util;

/**
 * Class JNews\Tiktok\Util
 */
class JNews_Tiktok_Render {
	/**
	 * @var integer
	 */
	private $row;
	private $column;
	private $count;

	/**
	 * @var string
	 */
	private $sort;
	private $hover;
	private $open;
	private $button;
	private $layout;
	private $cover;
	private $size;
	private $data;

	/**
	 * JNews\Tiktok\Util constructor
	 */
	public function __construct( $param, $tiktok_data = array(), $row = 1 ) {
		$this->row    = isset( $param['row']['size'] ) ? $param['row']['size'] : $param['row'];
		$this->column = isset( $param['column']['size'] ) ? $param['column']['size'] : $param['column'];
		$this->sort   = $param['sort'];
		$this->hover  = $param['hover'];
		$this->open   = $param['open'];
		$this->button = $param['button'];
		$this->layout = $param['layout'];
		$this->cover  = $param['cover'];
		$this->size   = 'rectangle' === $this->layout ? '1780' : '1000';
		$this->count  = $this->row * $this->column;
		$this->data = $tiktok_data; //see iQ4nWlII
	}

	/**
	 * @return Tiktok_Render
	 */
	public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}
	
	/**
	 * Render content
	 *
	 * @param array $data Tiktok data.
	 *
	 * @return string
	 */
	public function render_content( $data ) {
		//see iQ4nWlII
		$content = $like = '';
		$data    = array_slice( $data, 0, $this->count );

		if ( ! empty( $data ) && is_array( $data ) ) {
			switch ( $this->sort ) {
				case 'most_recent':
					usort(
						$data,
						function ( $a, $b ) {
							return $b['create_time'] - $a['create_time'];
						}
					);
					break;
				case 'least_recent':
					usort(
						$data,
						function ( $a, $b ) {
							return $a['create_time'] - $b['create_time'];
						}
					);
					break;
				case 'most_like':
					usort(
						$data,
						function ( $a, $b ) {
							return $b['like_count'] - $a['like_count'];
						}
					);
					break;
				case 'least_like':
					usort(
						$data,
						function ( $a, $b ) {
							return $a['like_count'] - $b['like_count'];
						}
					);
					break;
				case 'most_comment':
					usort(
						$data,
						function ( $a, $b ) {
							return $b['comment_count'] - $a['comment_count'];
						}
					);
					break;
				case 'least_comment':
					usort(
						$data,
						function ( $a, $b ) {
							return $a['comment_count'] - $b['comment_count'];
						}
					);
					break;
			}

			$a = 1;
			foreach ( $data as $image ) {
				if ( $this->hover == 'like' ) {
					$like = "<i class='fa fa-heart'>" . jnews_number_format( $image['like_count'] ) . '</i>';
				} elseif ( $this->hover == 'comment' ) {
					$like = "<i class='fa fa-comments'>" . jnews_number_format( $image['comment_count'] ) . '</i>';
				}

				$image_tag = apply_filters( 'jnews_single_image', $image['cover_image_url'], $image['title'], $this->size );

				$content .=
					"<li>
						<a href='{$image[ 'share_url' ]}' {$this->open}>
							{$like}
							{$image_tag}
						</a>
					</li>";

				if ( $a >= ( $this->row * $this->column ) ) {
					break;
				}

				$a ++;
			}
		}

		return $content;
	}

	/**
	 * Generate element
	 *
	 * @param boolean $echo echo the content or not.
	 *
	 * @return string
	 */
	public function generate_element( $echo = true ) {
		$view_button = '';
		$view_link   = jnews_tiktok_get_url( $this->data['user']['display_name'] ); //see iQ4nWlII

		if ( $view_button_option = $this->button ) {
			$view_button =
				"<h3 class='jeg_tiktok_heading'>
                    <a href='{$view_link}' {$this->open} class='jeg_btn-tiktok'>
                        <i class='fa fa-tiktok'></i>
                        <span>" . esc_html( $view_button_option ) . '</span>
                    </a>
                </h3>';
		}

		$content = $this->render_content( $this->data['feed'] ); //see iQ4nWlII

		$output = "<div class='jeg_tiktok_feed clearfix'>
                        {$view_button}
                        <ul class='tiktok-pics tiktok-size-large col{$this->column} {$this->hover}'>{$content}</ul>
                    </div>";

		if ( $echo ) {
			echo jnews_sanitize_output( $output );
		}

		return $output;
	}
}
