<?php

/**
 * @author : Jegtheme
 */

namespace JNews\Widget\Normal\Element;

use JNews\Widget\Normal\NormalWidgetInterface;
use JNews\Tiktok\Util\JNews_Tiktok_Api;

class TiktokWidget implements NormalWidgetInterface {
	/**
	 * @var  integer
	 */
	private $count;

	/**
	 * Tiktok widget option
	 *
	 * @return array
	 */
	public function get_options() {

		$tiktok_cached 		= get_option( 'jnews_tiktok_cached_data', array() );

		if ( is_array($tiktok_cached) && !empty( $tiktok_cached )  ) {
			return array(
				'title'    => array(
					'title' => esc_html__( 'Title', 'jnews-tiktok' ),
					'desc'  => esc_html__( 'Title on widget header.', 'jnews-tiktok' ),
					'type'  => 'text',
				),
	
				'column'   => array(
					'title'   => esc_html__( 'Set Column', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose number of column widget.', 'jnews-tiktok' ),
					'type'    => 'select',
					'default' => 3,
					'options' => array(
						2 => esc_html__( '2 Columns', 'jnews-tiktok' ),
						3 => esc_html__( '3 Columns', 'jnews-tiktok' ),
						4 => esc_html__( '4 Columns', 'jnews-tiktok' ),
					),
				),
	
				'row'      => array(
					'title'   => esc_html__( 'Set Row', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose number of row widget.', 'jnews-tiktok' ),
					'type'    => 'slider',
					'options' => array(
						'min'  => '1',
						'max'  => '10',
						'step' => '1',
					),
					'default' => 3,
				),
	
				'hover'    => array(
					'title'   => esc_html__( 'Hover Style', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose hover effect style.', 'jnews-tiktok' ),
					'type'    => 'select',
					'default' => 'normal',
					'options' => array(
						'normal'      => esc_html__( 'Normal', 'jnews-tiktok' ),
						'icon'        => esc_html__( 'Show Icon', 'jnews-tiktok' ),
						'like'        => esc_html__( 'Show Like Count', 'jnews-tiktok' ),
						'comment'     => esc_html__( 'Show Comment Count', 'jnews-tiktok' ),
						'zoom'        => esc_html__( 'Zoom', 'jnews-tiktok' ),
						'zoom-rotate' => esc_html__( 'Zoom Rotate', 'jnews-tiktok' ),
						''            => esc_html__( 'No Effect', 'jnews-tiktok' ),
					),
				),
	
				'sort'     => array(
					'title'   => esc_html__( 'Sort Type', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose sort type.', 'jnews-tiktok' ),
					'type'    => 'select',
					'default' => 'most_recent',
					'options' => array(
						'most_recent'   => esc_html__( 'Most Recent', 'jnews-tiktok' ),
						'least_recent'  => esc_html__( 'Least Recent', 'jnews-tiktok' ),
						'most_like'     => esc_html__( 'Most Liked', 'jnews-tiktok' ),
						'least_like'    => esc_html__( 'Least Liked', 'jnews-tiktok' ),
						'most_comment'  => esc_html__( 'Most Commented', 'jnews-tiktok' ),
						'least_comment' => esc_html__( 'Least Commented', 'jnews-tiktok' ),
					),
				),
	
				'button'   => array(
					'title' => esc_html__( 'View Button Text', 'jnews-tiktok' ),
					'desc'  => esc_html__( 'Leave it empty if you wont to show it.', 'jnews-tiktok' ),
					'type'  => 'text',
				),
	
				'layout'   => array(
					'title'   => esc_html__( 'Layout Type', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose layout type.', 'jnews-tiktok' ),
					'type'    => 'select',
					'default' => 'rectangle',
					'options' => array(
						'rectangle' => esc_html__( 'Rectangle', 'jnews-tiktok' ),
						'square'    => esc_html__( 'Square', 'jnews-tiktok' ),
					),
				),
	
				'cover'    => array(
					'title'   => esc_html__( 'Cover Type', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Choose cover type.', 'jnews-tiktok' ),
					'type'    => 'select',
					'default' => 'cover',
					'options' => array(
						'cover'   => esc_html__( 'Cover', 'jnews-tiktok' ),
						'origin'  => esc_html__( 'Origin', 'jnews-tiktok' ),
						'play'    => esc_html__( 'Play', 'jnews-tiktok' ),
						'dynamic' => esc_html__( 'Dynamic', 'jnews-tiktok' ),
					),
				),
	
				'open'     => array(
					'title'   => esc_html__( 'Open New Tab', 'jnews-tiktok' ),
					'desc'    => esc_html__( 'Open Tiktok profile on the new tab.', 'jnews-tiktok' ),
					'type'    => 'checkbox',
					'default' => false,
				),
			);
		}

		return array(
			'login_notice' => array(
				'title' => esc_html__( 'Tiktok Login Notice', 'jnews-tiktok' ),
				'desc'  => esc_html__( 'You\'re not logged into Tiktok, please login in Dashboard > Appearance > Customize > JNews : Social, Like & View > Tiktok Feed Setting', 'jnews-tiktok' ),
				'type'  => 'alert',
			),
		);
	}

	/**
	 * Render widget
	 *
	 * @param array   $instance Widget instance.
	 * @param null    $text_content
	 *
	 * @return string
	 */
	public function render_widget( $instance, $text_content = null ) {
		$tiktok_data = (new JNews_Tiktok_Api())->check_cache(); //see iQ4nWlII
		if($tiktok_data) {
			$this->row         = $instance['row'];
			$this->column      = $instance['column'];
			$this->count       = $this->row * $this->column;
			$this->hover       = $instance['hover'];
			$this->sort        = $instance['sort'];
			$this->newtab      = $instance['open'] ? 'target=\'_blank\'' : '';
			$this->button_link = jnews_tiktok_get_url( $tiktok_data['user']['display_name']  );
			$this->size        = 'rectangle' === $instance['layout'] ? '1780' : '1000';
			$this->cover       = $instance['cover'];

			if ( ! empty( $instance['button'] ) ) {
				$this->button =
					'<h3 class=\'jeg_tiktok_widget_heading\'>
					<a href=\'' . $this->button_link . '\' ' . $this->newtab . ' class=\'jeg_btn-tiktok\'><i class="fa fa-tiktok"></i><span>' . esc_html( $instance['button'] ) . '</span></a>
				</h3>';
			} else {
				$this->button = '';
			}

			$this->render_content( $tiktok_data['feed'] ); //see iQ4nWlII
		} else {
			echo jnews_sanitize_output( '<div class="jeg_empty_module">' . jnews_return_translation( 'You\'re not logged into Tiktok, please login', 'jnews-tiktok', 'tiktok_not_logged_in' ) . '<a href="' . get_site_url() . '/wp-admin/customize.php?autofocus[section]=jnews_tiktok_feed_section">' . jnews_return_translation( ' here', 'jnews-tiktok', 'tiktok_not_logged_in_here' ) .  '</a></div>' );
		}
		
	}

	/**
	 * Render content
	 *
	 * @param array tiktok data.
	 */
	protected function render_content( $data ) {
		$content = '';

		if ( ! empty( $data ) && is_array( $data ) ) {
			$data    = array_slice( $data, 0, $this->count );
			$data    = $this->sort_data( $data );
			$content = $this->build_content( $data );
		}

		$output =
			"<div class='jeg_tiktok_widget jeg_grid_thumb_widget clearfix'>
				{$this->button}    
				<ul class='tiktok-pics col{$this->column} {$this->hover}'>
					{$content}
				</ul>
			</div>";

		echo jnews_sanitize_output( $output );
	}

	/**
	 * Build content
	 *
	 * @param array tiktok data.
	 */
	protected function build_content( $data ) {
		$content = $like = '';
		$a       = 1;

		foreach ( $data as $image ) {
			if ( $a % $this->column == 0 ) {
				$class = 'last';
			} elseif ( $a % $this->column == 1 ) {
				$class = 'first';
			} else {
				$class = '';
			}

			if ( $this->hover == 'like' ) {
				$like = "<i class='fa fa-heart'>" . jnews_number_format( $image['like_count'] ) . '</i>';
			} elseif ( $this->hover == 'comment' ) {
				$like = "<i class='fa fa-comments'>" . jnews_number_format( $image['comment_count'] ) . '</i>';
			}

			$image_tag = apply_filters( 'jnews_single_image', $image['cover_image_url'], $image['title'], $this->size );

			$content .=
				"<li class='{$class}'>
                    <a href='{$image[ 'share_url' ]}' {$this->newtab}>
                        {$like}
                        {$image_tag}
                    </a>
                </li>";

			if ( $a >= ( $this->row * $this->column ) ) {
				break;
			}

			$a ++;
		}

		return $content;
	}

	/**
	 * sort tiktok data
	 *
	 * @param array tiktok data.
	 */
	protected function sort_data( $data ) {
		//see iQ4nWlII
		switch ( $this->sort ) {
			case 'most_recent':
				usort(
					$data,
					function ( $a, $b ) {
						return $b['create_time'] - $a['create_time'];
					}
				);
				break;
			case 'least_recent':
				usort(
					$data,
					function ( $a, $b ) {
						return $a['create_time'] - $b['create_time'];
					}
				);
				break;
			case 'most_like':
				usort(
					$data,
					function ( $a, $b ) {
						return $b['like_count'] - $a['like_count'];
					}
				);
				break;
			case 'least_like':
				usort(
					$data,
					function ( $a, $b ) {
						return $a['like_count'] - $b['like_count'];
					}
				);
				break;
			case 'most_comment':
				usort(
					$data,
					function ( $a, $b ) {
						return $b['comment'] - $a['comment'];
					}
				);
				break;
			case 'least_comment':
				usort(
					$data,
					function ( $a, $b ) {
						return $a['comment_count'] - $b['comment_count'];
					}
				);
				break;
		}

		return $data;
	}

	protected function get_widget_template() {
	}
}
