<?php

/**
 * JNews Tiktok Feed Helper
 *
 * @author Jegtheme
 * @since 1.0.0
 * @package jnews-tiktok
 */

/**
 * Get jnews option
 *
 * @param $setting
 * @param $default
 *
 * @return mixed
 */
if ( ! function_exists( 'jnews_get_option' ) ) {
	function jnews_get_option( $setting, $default = null ) {
		$options = get_option( 'jnews_option', array() );
		$value   = $default;

		if ( isset( $options[ $setting ] ) ) {
			$value = $options[ $setting ];
		}

		return $value;
	}
}

/**
 * Load Text Domain
 */
function jnews_tiktok_load_textdomain() {
	load_plugin_textdomain( JNEWS_TIKTOK, false, basename( __DIR__ ) . '/languages/' );
}

jnews_tiktok_load_textdomain();

if ( ! function_exists( 'jnews_tiktok_get_url' ) ) {
	function jnews_tiktok_get_url( $username) {
		return JNEWS_TIKTOK_DEFAULT_URL . '@' . $username;
	}
}
