<?php
/**
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wmme_Export_Controller {

	public static function sites() {
		if ( is_multisite() ) {
			Ai1wm_Template::render( 'export/sites', array(), AI1WMME_TEMPLATES_PATH );
		}
	}

	public static function sites_paginator( $params = array() ) {
		ai1wm_setup_environment();

		// Set params
		if ( empty( $params ) ) {
			$params = stripslashes_deep( $_GET );
		}

		// Set current page
		if ( isset( $params['current'] ) ) {
			$current = intval( $params['current'] );
		} else {
			$current = 1;
		}

		$count = ai1wmme_count_sites();

		// Set sites per page
		if ( ! ( $per_page = get_user_option( 'sites_network_per_page' ) ) ) {
			$per_page = 10;
		}

		echo json_encode(
			array(
				'count'   => $count,
				'current' => $current,
				'pages'   => ceil( $count / $per_page ),
				'sites'   => ai1wmme_paginate_sites( ( $current - 1 ) * $per_page, $per_page ),
			)
		);
		exit;
	}
}
